/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.tools.report.appenders.IFlushableAppenders;

public class ReportManagerActivator
extends Plugin {
    private static final Logger logger = Logger.getLogger((String)ReportManagerActivator.class.getName());
    private static final String APPENDERS_EXTENSION_ID = "Log4jAppendersExtension";
    private static final String FLUSHABLE_APPENDERS_EXTENSION_ID = "AppenderOutputFlushCapability";
    private static ReportManagerActivator plugin;
    private static final String REPORT_PLUGIN_ID = "org.polarsys.capella.common.tools.report";
    private List<Appender> appenders;
    private List<IFlushableAppenders> flushableAppenders;

    public ReportManagerActivator() {
        plugin = this;
    }

    public List<Appender> getAppenders() {
        if (this.appenders == null || this.appenders.isEmpty()) {
            try {
                IConfigurationElement[] appendersProvider;
                this.appenders = new ArrayList<Appender>();
                IConfigurationElement[] iConfigurationElementArray = appendersProvider = ExtensionPointHelper.getConfigurationElements((String)REPORT_PLUGIN_ID, (String)APPENDERS_EXTENSION_ID);
                int n = appendersProvider.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    Appender newAppender = (Appender)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                    if (newAppender != null) {
                        this.appenders.add(newAppender);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return this.appenders;
    }

    public List<IFlushableAppenders> getFlushableAppenders() {
        if (this.flushableAppenders == null || this.flushableAppenders.isEmpty()) {
            try {
                IConfigurationElement[] appendersProvider;
                this.flushableAppenders = new ArrayList<IFlushableAppenders>();
                IConfigurationElement[] iConfigurationElementArray = appendersProvider = ExtensionPointHelper.getConfigurationElements((String)REPORT_PLUGIN_ID, (String)FLUSHABLE_APPENDERS_EXTENSION_ID);
                int n = appendersProvider.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    IFlushableAppenders newAppender = (IFlushableAppenders)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                    this.flushableAppenders.add(newAppender);
                    ++n2;
                }
            }
            catch (Exception ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return this.flushableAppenders;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.getAppenders();
        this.getFlushableAppenders();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ReportManagerActivator getDefault() {
        return plugin;
    }
}

