/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.links.helpers;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.model.helpers.refmap.VPair;
import org.polarsys.capella.core.model.links.helpers.CapellaLinksMap;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractQueryBasedCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddCompExchangeToCompExchangeCat;
import org.polarsys.capella.core.model.links.helpers.commands.AddComponentExchangeToPhysicalLinkCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddExchangeCategoryToFunctionalExchangeCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddExchangeCategoryToPhysicalLinkCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddExchangeItemToComponentExchangeCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddExchangeItemToFunctionExchange;
import org.polarsys.capella.core.model.links.helpers.commands.AddExchangeItemToFunctionPort;
import org.polarsys.capella.core.model.links.helpers.commands.AddFunctionalExchangeToComponentExchangeCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddModeStateToCapabilityCommand;
import org.polarsys.capella.core.model.links.helpers.commands.AddModeStateToFunctionCommand;
import org.polarsys.capella.core.model.links.helpers.commands.CreateAssociationCommand;
import org.polarsys.capella.core.model.links.helpers.commands.CreateComponentExchangeAllocation;
import org.polarsys.capella.core.model.links.helpers.commands.CreateExchangeItemAllocationCommand;
import org.polarsys.capella.core.model.links.helpers.commands.CreateFunctionalAllocationCommand;
import org.polarsys.capella.core.model.links.helpers.commands.CreateFunctionalExchangeAllocation;
import org.polarsys.capella.core.model.links.helpers.commands.CreateGeneralizationsCommand;
import org.polarsys.capella.core.model.links.helpers.commands.CreateRealizationLinksCommand;

public class LinksCommandRegistry {
    private static LinksCommandRegistry __instance;
    private final Map<CommandScope, Class<?>> _commandScopeToCommand = new HashMap();

    private LinksCommandRegistry() {
    }

    public boolean containsCommandForSourceTargetTypes(EClass sourceType, EClass targetType) {
        VPair vPair = CapellaLinksMap.getInstance().getMappingFor(sourceType, targetType);
        if (vPair == null) {
            return false;
        }
        return this.containsCommandForVPairs(Collections.singletonList(vPair));
    }

    public boolean containsCommandForSourceType(EClass sourceType) {
        List<VPair> vPairs = CapellaLinksMap.getInstance().findMappingsForSourceType(sourceType);
        return this.containsCommandForVPairs(vPairs);
    }

    public boolean containsCommandForTargetType(EClass targetType) {
        List<VPair> vPairs = CapellaLinksMap.getInstance().findMappingsForTargetType(targetType);
        return this.containsCommandForVPairs(vPairs);
    }

    protected boolean containsCommandForVPairs(List<VPair> vPairs) {
        for (VPair vPair : vPairs) {
            EClass[] linkTypes = (EClass[])vPair.getFirstValue();
            EReference[] linkReferencesInSource = (EReference[])vPair.getSecondValue();
            int i = 0;
            while (i < linkTypes.length && i < linkReferencesInSource.length) {
                for (CommandScope commandScope : this._commandScopeToCommand.keySet()) {
                    if (!commandScope.isValidFor(linkTypes[i], linkReferencesInSource[i])) continue;
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void executeCommand(EObject context, final AbstractCreateLinksCommand commandToExecute) {
        AbstractReadWriteCommand command = new AbstractReadWriteCommand(){

            public void run() {
                commandToExecute.execute();
            }
        };
        TransactionHelper.getExecutionManager((EObject)context).execute((ICommand)command);
    }

    private List<Class<?>> findCommandsFor(EClass linkType, EReference linkRef) {
        ArrayList commands = new ArrayList();
        for (Map.Entry<CommandScope, Class<?>> entry : this._commandScopeToCommand.entrySet()) {
            if (!entry.getKey().isValidFor(linkType, linkRef)) continue;
            commands.add(entry.getValue());
        }
        return commands;
    }

    public List<AbstractCreateLinksCommand> getExecutableCommands(Collection<EObject> source, Collection<EObject> target) {
        if (source == null || target == null) {
            return Collections.emptyList();
        }
        ArrayList<AbstractCreateLinksCommand> executableCommands = new ArrayList<AbstractCreateLinksCommand>();
        VPair vPair = CapellaLinksMap.getInstance().getMappingFor(source.iterator().next().eClass(), target.iterator().next().eClass());
        if (vPair == null) {
            return Collections.emptyList();
        }
        int i = 0;
        while (i < ((EClass[])vPair.getFirstValue()).length && i < ((EReference[])vPair.getSecondValue()).length) {
            EClass linkType = ((EClass[])vPair.getFirstValue())[i];
            EReference linkReference = ((EReference[])vPair.getSecondValue())[i];
            List<Class<?>> commandClasses = this.findCommandsFor(linkType, linkReference);
            for (Class<?> commandClass : commandClasses) {
                try {
                    AbstractCreateLinksCommand commandInstance = null;
                    if (AbstractQueryBasedCommand.class.isAssignableFrom(commandClass)) {
                        Constructor<?> constructor = commandClass.getConstructor(EClass.class, EReference.class);
                        commandInstance = (AbstractCreateLinksCommand)((Object)constructor.newInstance(linkType, linkReference));
                    } else {
                        commandInstance = (AbstractCreateLinksCommand)((Object)commandClass.newInstance());
                    }
                    commandInstance.setSources((ArrayList)source);
                    commandInstance.setTargets((ArrayList)target);
                    if (!commandInstance.canExecute()) continue;
                    executableCommands.add(commandInstance);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        return executableCommands;
    }

    public static LinksCommandRegistry getInstance() {
        if (__instance == null) {
            __instance = new LinksCommandRegistry();
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(CsPackage.Literals.COMPONENT_REALIZATION, null), CreateRealizationLinksCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION, null), CreateFunctionalAllocationCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(FaPackage.Literals.FUNCTION_REALIZATION, null), CreateRealizationLinksCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(CapellacorePackage.Literals.GENERALIZATION, null), CreateGeneralizationsCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION, null), CreateExchangeItemAllocationCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(InformationPackage.Literals.ASSOCIATION, null), CreateAssociationCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATION, null), CreateComponentExchangeAllocation.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(FaPackage.Literals.COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATION, null), CreateFunctionalExchangeAllocation.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.COMPONENT_EXCHANGE_CATEGORY__EXCHANGES), AddCompExchangeToCompExchangeCat.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.FUNCTION_INPUT_PORT__INCOMING_EXCHANGE_ITEMS), AddExchangeItemToFunctionPort.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.FUNCTION_OUTPUT_PORT__OUTGOING_EXCHANGE_ITEMS), AddExchangeItemToFunctionPort.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.FUNCTIONAL_EXCHANGE__EXCHANGED_ITEMS), AddExchangeItemToFunctionExchange.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATION, FaPackage.Literals.COMPONENT_EXCHANGE__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS), AddFunctionalExchangeToComponentExchangeCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__CONVOYED_INFORMATIONS), AddExchangeItemToComponentExchangeCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, CsPackage.Literals.PHYSICAL_LINK__OWNED_COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATIONS), AddComponentExchangeToPhysicalLinkCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.EXCHANGE_CATEGORY__EXCHANGES), AddExchangeCategoryToFunctionalExchangeCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, CsPackage.Literals.PHYSICAL_LINK_CATEGORY__LINKS), AddExchangeCategoryToPhysicalLinkCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, FaPackage.Literals.ABSTRACT_FUNCTION__AVAILABLE_IN_STATES), AddModeStateToFunctionCommand.class);
            LinksCommandRegistry.__instance._commandScopeToCommand.put(new CommandScope(null, InteractionPackage.Literals.ABSTRACT_CAPABILITY__AVAILABLE_IN_STATES), AddModeStateToCapabilityCommand.class);
        }
        return __instance;
    }

    public Map<CommandScope, Class<?>> getCommandregistry() {
        return this._commandScopeToCommand;
    }

    public static class CommandScope {
        public EReference _linkReferenceInSource;
        public EClass _linkSuperType;

        public CommandScope(EClass linkSuperType, EReference linkReferenceInSource) {
            this._linkSuperType = linkSuperType;
            this._linkReferenceInSource = linkReferenceInSource;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CommandScope other = (CommandScope)obj;
            if (this._linkReferenceInSource == null ? other._linkReferenceInSource != null : !this._linkReferenceInSource.equals(other._linkReferenceInSource)) {
                return false;
            }
            return !(this._linkSuperType == null ? other._linkSuperType != null : !this._linkSuperType.equals(other._linkSuperType));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._linkReferenceInSource == null ? 0 : this._linkReferenceInSource.hashCode());
            result = 31 * result + (this._linkSuperType == null ? 0 : this._linkSuperType.hashCode());
            return result;
        }

        public boolean isValidFor(EClass linkType, EReference linkReferenceInSource) {
            if (!(this._linkSuperType == null || linkType != null && this._linkSuperType.isSuperTypeOf(linkType))) {
                return false;
            }
            return this._linkReferenceInSource == null || this._linkReferenceInSource == linkReferenceInSource;
        }
    }
}

