/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.provider;

import java.util.ArrayList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.libraries.provider.AbstractLibraryProvider;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.libraries.model.ModelIdentifier;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;

public abstract class AbstractCapellaProvider
extends AbstractLibraryProvider {
    protected Resource getResource(TransactionalEditingDomain domain, URI uri, boolean resolve) {
        try {
            return domain.getResourceSet().getResource(uri, resolve);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected ModelIdentifier createModelIdentifier(Resource resource) {
        return CapellaModel.createModelIdentifier(resource);
    }

    protected IModel createModel(ModelIdentifier identifier, TransactionalEditingDomain domain) {
        return CapellaModel.createModel(identifier, domain);
    }

    protected boolean isHandled(URI uri) {
        return false;
    }

    public IModel getModel(TransactionalEditingDomain domain) {
        ArrayList<Resource> toCheck = new ArrayList<Resource>();
        for (Resource resource : domain.getResourceSet().getResources()) {
            if (!this.isHandled(resource.getURI()) || CapellaResourceHelper.isCapellaFragment((URI)resource.getURI()) || !resource.getErrors().isEmpty()) continue;
            toCheck.add(resource);
        }
        ArrayList<IModel> models = new ArrayList<IModel>();
        for (Resource resource : toCheck) {
            IModel model = this.createModel(this.createModelIdentifier(resource), domain);
            if (model == null || models.contains(model)) continue;
            models.add(model);
        }
        IModel result = null;
        if (models.size() > 1) {
            for (IModel model : new ArrayList(models)) {
                for (IModel reference : LibraryManagerExt.getAllReferences((IModel)model)) {
                    models.remove(reference);
                }
            }
        }
        if (!models.isEmpty()) {
            result = (IModel)models.iterator().next();
        }
        return result;
    }

    public IModel getModel(EObject object) {
        Resource resource;
        EObject semanticElement = object;
        if (semanticElement == null) {
            return null;
        }
        if (!CapellaResourceHelper.isSemanticElement((Object)semanticElement)) {
            semanticElement = CapellaAdapterHelper.resolveSemanticObject((Object)semanticElement);
        }
        TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)object);
        if (semanticElement != null && (resource = semanticElement.eResource()) != null && this.isHandled(resource.getURI())) {
            if (CapellaResourceHelper.isCapellaResource((Resource)resource)) {
                return this.createModel(this.createModelIdentifier(resource), domain);
            }
            ModelIdentifier identifier = this.createModelIdentifier(resource);
            return ILibraryManager.INSTANCE.getModel(domain, (IModelIdentifier)identifier);
        }
        return null;
    }
}

