/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.capellamodeller.validation;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHKPackageVisibility
extends AbstractValidationRule {
    private Set<IStatus> statuses;

    private boolean isImpactedElement(ModelElement modelElement) {
        return modelElement != null && modelElement instanceof Class || modelElement != null && modelElement instanceof Collection || modelElement != null && modelElement instanceof DataType;
    }

    public IStatus validate(IValidationContext context) {
        EObject eObj = context.getTarget();
        EMFEventType eType = context.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof SystemEngineering) {
            this.statuses = new HashSet<IStatus>();
            SystemEngineering system = (SystemEngineering)eObj;
            List allPackages = SystemEngineeringExt.getAllDataPkgs((SystemEngineering)system);
            for (DataPkg aPackage : allPackages) {
                this.validateAssociation(context, aPackage);
                this.validateGeneralization(context, aPackage);
            }
            if (!this.statuses.isEmpty()) {
                return ConstraintStatus.createMultiStatus((IValidationContext)context, this.statuses);
            }
        }
        return context.createSuccessStatus();
    }

    private void validateAssociation(IValidationContext context, DataPkg aPackage) {
        EList associations = aPackage.getOwnedAssociations();
        for (Association association : associations) {
            this.validatePackageVisibility(context, (Relationship)association, aPackage);
        }
    }

    private void validateGeneralization(IValidationContext context, DataPkg aPackage) {
        Set generalizations = DataPkgExt.getAllGeneralization((DataPkg)aPackage);
        for (Generalization generalization : generalizations) {
            this.validatePackageVisibility(context, (Relationship)generalization, aPackage);
        }
    }

    private void validatePackageVisibility(IValidationContext context, Relationship relation, DataPkg aPackage) {
        boolean isAncestorNavigablePackage;
        GeneralizableElement sourceElement = null;
        GeneralizableElement targetElement = null;
        DataPkg sourcePackage = null;
        DataPkg targetPackage = null;
        if (relation instanceof Association) {
            Association association = (Association)relation;
            if (!association.getNavigableMembers().isEmpty() && !association.getOwnedMembers().isEmpty()) {
                Property navigableMember = (Property)association.getNavigableMembers().get(0);
                Property ownedMemmber = (Property)association.getOwnedMembers().get(0);
                if (this.isImpactedElement((ModelElement)ownedMemmber.getAbstractType()) && this.isImpactedElement((ModelElement)navigableMember.getAbstractType())) {
                    sourceElement = (GeneralizableElement)ownedMemmber.getAbstractType();
                    targetElement = (GeneralizableElement)navigableMember.getAbstractType();
                    sourcePackage = (DataPkg)sourceElement.eContainer();
                    targetPackage = (DataPkg)targetElement.eContainer();
                }
            }
        } else if (relation instanceof Generalization) {
            Generalization generalization = (Generalization)relation;
            targetElement = generalization.getSuper();
            sourceElement = generalization.getSub();
            if (this.isImpactedElement((ModelElement)sourceElement) && this.isImpactedElement((ModelElement)targetElement)) {
                sourcePackage = (DataPkg)sourceElement.eContainer();
                targetPackage = (DataPkg)targetElement.eContainer();
            }
        }
        boolean bl = isAncestorNavigablePackage = targetPackage != null && sourcePackage != null && DataPkgExt.isAncestorPackage(targetPackage, sourcePackage);
        if (isAncestorNavigablePackage) {
            String SOURCE_PREFIXE = "\"" + sourceElement.getName() + "\" ( " + sourceElement.eClass().getName() + " ) ";
            String TARGET_PREFIXE = "\"" + targetElement.getName() + "\" ( " + targetElement.eClass().getName() + " ) ";
            this.statuses.add(this.createFailureStatus(context, new Object[]{SOURCE_PREFIXE, TARGET_PREFIXE}));
        }
    }
}

