/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class DelegationOutOfPlace
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        ComponentExchange exchagne;
        ComponentExchangeKind kind;
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange && (kind = (exchagne = (ComponentExchange)eObj).getKind()).equals((Object)ComponentExchangeKind.DELEGATION)) {
            Collection sourceParts = ComponentExchangeExt.getSourceParts((ComponentExchange)exchagne);
            Collection targetParts = ComponentExchangeExt.getTargetParts((ComponentExchange)exchagne);
            if (sourceParts == null || sourceParts.isEmpty() || targetParts == null || targetParts.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{String.valueOf(exchagne.getName()) + " (Component Exchange) of kind Delegation is not valid (could not find source of target element)."});
            }
            boolean flag = false;
            for (Part part : targetParts) {
                Collection firstPartAncestors = PartExt.getFirstPartAncestors((Part)part);
                for (Part part2 : firstPartAncestors) {
                    if (!sourceParts.contains(part2)) continue;
                    flag = true;
                    break;
                }
                if (flag) break;
            }
            if (!flag) {
                return ctx.createFailureStatus(new Object[]{String.valueOf(exchagne.getName()) + " (Component Exchange) of kind Delegation is out of place and useless."});
            }
        }
        return ctx.createSuccessStatus();
    }
}

