/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.sequenceLink;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.validation.sequenceLink.SequenceLinkEndStatusHelper;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class SequenceLinkHasEmptyCondition
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        SequenceLink seqLink;
        if (ctx.getEventType() == EMFEventType.NULL && ctx.getTarget() instanceof SequenceLink && !this.hasCondition(seqLink = (SequenceLink)ctx.getTarget())) {
            return ctx.createFailureStatus(ArrayUtils.addAll((Object[])SequenceLinkEndStatusHelper.getStatusInfo(seqLink.getSource()), (Object[])SequenceLinkEndStatusHelper.getStatusInfo(seqLink.getTarget())));
        }
        return ctx.createSuccessStatus();
    }

    private boolean hasCondition(SequenceLink seqLink) {
        boolean hasCondition = false;
        if (seqLink.getCondition() != null) {
            String constraint = CapellaServices.getService().getConstraintLabel(seqLink.getCondition());
            hasCondition = !constraint.isEmpty();
        }
        return hasCondition;
    }
}

