/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.ui.quickfix.resolver;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.text.BadLocationException;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextDocument;
import org.polarsys.capella.common.linkedtext.ui.LinkedTextHyperlink;
import org.polarsys.capella.core.data.information.datavalue.OpaqueExpression;
import org.polarsys.capella.core.linkedtext.ui.CapellaEmbeddedLinkedTextEditorInput;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class CleanReferenceElementResolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        EObject value = (EObject)this.getModelElements(marker).get(0);
        if (value instanceof OpaqueExpression) {
            OpaqueExpression opExpression = (OpaqueExpression)value;
            this.cleanDeletedHyperLink(opExpression);
            try {
                marker.delete();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public void cleanDeletedHyperLink(final OpaqueExpression opExpression) {
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)opExpression);
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                EList listBody = opExpression.getBodies();
                int i = 0;
                while (i < listBody.size()) {
                    String body = (String)listBody.get(i);
                    CapellaEmbeddedLinkedTextEditorInput.Readonly input = new CapellaEmbeddedLinkedTextEditorInput.Readonly((EObject)opExpression, body);
                    try {
                        LinkedTextDocument doc = LinkedTextDocument.load((LinkedTextDocument.Input)input);
                        for (LinkedTextHyperlink hl : doc.getHyperlinks()) {
                            Object o = hl.getTarget();
                            if (o != null) continue;
                            try {
                                doc.replace(hl.offset, hl.length, "");
                                hl.delete();
                            }
                            catch (BadLocationException e) {
                                e.printStackTrace();
                            }
                        }
                        String content = doc.saveToRaw();
                        int position = i++;
                        opExpression.getBodies().set(position, (Object)content);
                    }
                    finally {
                        input.dispose();
                    }
                }
            }
        });
    }
}

