/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.ctx.validation.systemComponent;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class SystemComponent_InvolvedMissionsAndCapabilitiesConforms
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof SystemComponent) {
            SystemComponent actor = (SystemComponent)eObj;
            String missionsNames = "";
            boolean ok = false;
            for (Mission mission : actor.getInvolvingMissions()) {
                ok = false;
                for (Capability capability : mission.getExploitedCapabilities()) {
                    if (!actor.getInvolvingCapabilities().contains((Object)capability)) continue;
                    ok = true;
                    break;
                }
                if (ok) continue;
                if (missionsNames.length() > 0) {
                    missionsNames = String.valueOf(missionsNames) + ',' + ' ';
                }
                missionsNames = String.valueOf(missionsNames) + mission.getName();
            }
            if (missionsNames.length() > 0) {
                return ctx.createFailureStatus(new Object[]{CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)actor), missionsNames});
            }
        }
        return ctx.createSuccessStatus();
    }
}

