/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.gen.edit.decorators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.ItemProviderDecorator;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.data.gen.edit.decorators.IDelegatedDecorator;

public class ItemProviderAdapterDecorator
extends ItemProviderDecorator
implements Adapter.Internal {
    private List<Notifier> targets;
    private static Map<String, List<IDelegatedDecorator>> directContributors;
    private static Map<String, List<IDelegatedDecorator>> allContributors;
    private static Map<IDelegatedDecorator, String> contributorPositions;
    private static final String PLUGIN_ID = "org.polarsys.capella.core.data.gen.edit.decorators";
    private static final String EXTENSION_POINT_ID = "delegatedDecorator";
    protected static final String DECORATOR_POSITION_OVERRIDES = "overrides";
    protected static final String DECORATOR_POSITION_PREFIX = "prefix";
    protected static final String DECORATOR_POSITION_SUFFIX = "suffix";
    protected static final String DECORATOR_ATTRIBUTE_POSITION = "position";
    protected static final String DECORATOR_ATTRIBUTE_TYPE = "type";
    protected static final String DECORATOR_ATTRIBUTE_CLASS = "class";

    public ItemProviderAdapterDecorator(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public String getText(Object object) {
        StringBuilder text = new StringBuilder(super.getText(object));
        for (IDelegatedDecorator labelProvider : this.getDelegatedDecorators((EObject)object)) {
            if (!labelProvider.appliesTo(object)) continue;
            String position = this.getDecoratorPosition(labelProvider);
            if (DECORATOR_POSITION_PREFIX.equals(position)) {
                text.insert(0, labelProvider.getText(object));
                continue;
            }
            if (DECORATOR_POSITION_SUFFIX.equals(position)) {
                text.append(labelProvider.getText(object));
                continue;
            }
            if (!DECORATOR_POSITION_OVERRIDES.equals(position)) continue;
            text.replace(0, text.length(), labelProvider.getText(object));
        }
        return text.toString();
    }

    protected String getDecoratorPosition(IDelegatedDecorator labelProvider) {
        if (labelProvider == null) {
            return "";
        }
        if (contributorPositions == null) {
            this.fillContributorsCache();
        }
        return contributorPositions.get(labelProvider);
    }

    protected List<IDelegatedDecorator> getDelegatedDecorators(EObject eobject) {
        if (eobject == null) {
            return Collections.emptyList();
        }
        if (directContributors == null) {
            this.fillContributorsCache();
        }
        return this.getContributorsPerType(eobject.eClass());
    }

    private List<IDelegatedDecorator> getContributorsPerType(EClass clazz) {
        if (!allContributors.containsKey(clazz.getInstanceClassName())) {
            List<Object> result = new ArrayList(2);
            List<IDelegatedDecorator> current = directContributors.get(clazz.getInstanceClassName());
            if (current != null) {
                for (IDelegatedDecorator next : current) {
                    if (result.contains(next)) continue;
                    result.add(next);
                }
            }
            for (EClass superType : clazz.getEAllSuperTypes()) {
                for (IDelegatedDecorator next : this.getContributorsPerType(superType)) {
                    if (result.contains(next)) continue;
                    result.add(next);
                }
            }
            if (result.isEmpty()) {
                result = Collections.emptyList();
            }
            allContributors.put(clazz.getInstanceClassName(), result);
        }
        return allContributors.get(clazz.getInstanceClassName());
    }

    private void fillContributorsCache() {
        directContributors = new HashMap<String, List<IDelegatedDecorator>>();
        contributorPositions = new HashMap<IDelegatedDecorator, String>();
        allContributors = new HashMap<String, List<IDelegatedDecorator>>();
        IConfigurationElement[] iConfigurationElementArray = ExtensionPointHelper.getConfigurationElements((String)PLUGIN_ID, (String)EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement provider = iConfigurationElementArray[n2];
            String type = provider.getAttribute(DECORATOR_ATTRIBUTE_TYPE);
            List<IDelegatedDecorator> labelProviders = directContributors.get(type);
            if (labelProviders == null) {
                labelProviders = new ArrayList<IDelegatedDecorator>();
                directContributors.put(type, labelProviders);
            }
            IDelegatedDecorator cls = (IDelegatedDecorator)ExtensionPointHelper.createInstance((IConfigurationElement)provider, (String)DECORATOR_ATTRIBUTE_CLASS);
            labelProviders.add(cls);
            String position = provider.getAttribute(DECORATOR_ATTRIBUTE_POSITION);
            contributorPositions.put(cls, position == null ? "" : position);
            ++n2;
        }
    }

    protected AdapterFactory getRootAdapterFactory() {
        if (this.adapterFactory instanceof ComposeableAdapterFactory) {
            return ((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory();
        }
        return this.adapterFactory;
    }

    protected Object overlayImage(Object object, Object image) {
        if (AdapterFactoryEditingDomain.isControlled((Object)object)) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(EMFEditPlugin.INSTANCE.getImage("full/ovr16/ControlledObject"));
            image = new ComposedImage(images);
        }
        return image;
    }

    public Notifier getTarget() {
        if (this.targets == null || this.targets.isEmpty()) {
            return null;
        }
        return this.targets.get(this.targets.size() - 1);
    }

    public void setTarget(Notifier newTarget) {
        if (this.targets == null) {
            this.targets = new ArrayList<Notifier>();
        }
        this.targets.add(newTarget);
    }

    public void unsetTarget(Notifier oldTarget) {
        if (this.targets != null) {
            this.targets.remove(oldTarget);
        }
    }
}

