/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.menu.contributions.epbs;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.menu.dynamic.contributions.IMDEMenuItemContribution;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.impl.cmd.CreateEPBSArchiCmd;

public class EPBSArchitectureItemContribution
implements IMDEMenuItemContribution {
    public boolean selectionContribution(ModelElement modelElement, EClass cls, EStructuralFeature feature) {
        if (modelElement instanceof SystemEngineering && EpbsPackage.Literals.EPBS_ARCHITECTURE.equals(cls) && CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES.equals(feature)) {
            return ((SystemEngineering)modelElement).getContainedEPBSArchitectures().isEmpty();
        }
        return false;
    }

    public Command executionContribution(EditingDomain editingDomain, ModelElement containerElement, final ModelElement createdElement, EStructuralFeature feature) {
        if (createdElement instanceof EPBSArchitecture && containerElement instanceof SystemEngineering) {
            final SystemEngineering engineering = (SystemEngineering)containerElement;
            final PhysicalArchitecture architecture = SystemEngineeringExt.getPhysicalArchitecture((SystemEngineering)engineering);
            return new RecordingCommand((TransactionalEditingDomain)editingDomain){

                protected void doExecute() {
                    new CreateEPBSArchiCmd(engineering, NamingConstants.CreateEPBSArchCmd_name, architecture, (PhysicalComponent)architecture.getSystem(), (EPBSArchitecture)createdElement).run();
                }
            };
        }
        return new IdentityCommand();
    }

    public EClass getMetaclass() {
        return EpbsPackage.Literals.EPBS_ARCHITECTURE;
    }
}

