/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.internal.session;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.model.handler.internal.session.Messages;

public class CapellaSavingPolicyHelper {
    private CapellaSavingPolicyHelper() {
    }

    public static void checkUnsaveableFiles(Iterable<Resource> allResources) {
        Collection<IFile> files = CapellaSavingPolicyHelper.retrieveUnsaveableFiles(allResources);
        if (!files.isEmpty()) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.CapellaSavingPolicy_unwriteableFiles);
            for (IFile file : files) {
                msg.append(String.valueOf(file.toString()) + '\n');
            }
            throw new RuntimeException(msg.toString());
        }
    }

    public static Collection<IFile> retrieveUnsaveableFiles(Iterable<Resource> allResources) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        for (Resource resource : allResources) {
            IPath path;
            IPath parentFolderPath;
            File dir;
            IFile file;
            if (resource == null || (file = EcoreUtil2.getFile((Resource)resource)) == null || !(dir = (parentFolderPath = (path = file.getLocation()).removeLastSegments(1)).toFile()).exists() || dir.canWrite()) continue;
            files.add(file);
        }
        return files;
    }
}

