/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.sirius.ui.Messages;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.closeproject.SessionCloseManager;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CloseSessionAction
extends BaseSelectionListenerAction {
    private boolean showDialog;
    private boolean shouldSaveIfNoDialog;

    public CloseSessionAction() {
        super(Messages.CloseSessionAction_Title);
        this.setActionDefinitionId("org.eclipse.ui.file.close");
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.ui", (String)"/icons/full/others/close.gif"));
        this.showDialog = true;
    }

    public void showDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public void shouldSaveIfNoDialog(boolean save) {
        this.shouldSaveIfNoDialog = save;
    }

    public void run() {
        List<Session> sessions = this.getSessionsFromSelection(this.getStructuredSelection());
        CloseSessionOperation closeSessionOperation = new CloseSessionOperation(sessions);
        Shell activeShell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        SiriusUIPlugin.getDefault().runSaveOperation(activeShell, closeSessionOperation);
    }

    private List<Session> getSessionsFromSelection(IStructuredSelection selection) {
        ArrayList<Session> sessions = new ArrayList<Session>(0);
        for (Object selectedElement : selection) {
            Session session;
            if (selectedElement instanceof Session) {
                sessions.add((Session)selectedElement);
                continue;
            }
            if (!(selectedElement instanceof IFile) || (session = SessionHelper.getSessionForDiagramFile((IFile)selectedElement)) == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Iterator<Session> sessions = this.getSessionsFromSelection(selection).iterator();
        boolean isOneSessionClosed = false;
        while (sessions.hasNext() && !isOneSessionClosed) {
            Session selectedSession = sessions.next();
            boolean bl = isOneSessionClosed = !selectedSession.isOpen();
        }
        return !isOneSessionClosed;
    }

    private class CloseSessionCommand
    extends AbstractNonDirtyingCommand {
        private Session session;

        public CloseSessionCommand(Session session) {
            this.session = session;
        }

        protected void closeSession(Session session, boolean saveIsNeeded) {
            IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
            if (uiSession != null) {
                SessionCloseManager.closeUISession(uiSession, saveIsNeeded);
            }
            SessionCloseManager.closeSession(session);
        }

        public void run() {
            boolean saveIsNeeded;
            int choice = 1;
            if (SessionCloseManager.isDirty(this.session)) {
                if (CloseSessionAction.this.showDialog) {
                    choice = SWTUtil.showSaveDialog((Object)this.session, (String)"Session", (boolean)true);
                } else {
                    int n = choice = CloseSessionAction.this.shouldSaveIfNoDialog ? 0 : 1;
                }
            }
            if (2 == choice) {
                return;
            }
            boolean bl = saveIsNeeded = choice == 0;
            if (saveIsNeeded) {
                try {
                    SessionCloseManager.saveSession(this.session);
                }
                catch (RuntimeException e) {
                    String msg = NLS.bind((String)Messages.unableToSaveDuringCloseOpsDialog_BottomQuestion, (Object)e.getMessage());
                    Shell activeShell = Display.getCurrent().getActiveShell();
                    if (!MessageDialog.openQuestion((Shell)activeShell, (String)Messages.CloseSessionAction_Title, (String)msg)) {
                        return;
                    }
                    saveIsNeeded = false;
                }
            }
            String eventName = "Close Session";
            IFile resourceFile = EcoreUtil2.getFile((Resource)this.session.getSessionResource());
            String eventContext = resourceFile != null ? resourceFile.getName() : "";
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE);
            this.closeSession(this.session, saveIsNeeded);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK);
        }
    }

    public class CloseSessionOperation
    implements IRunnableWithProgress {
        private List<Session> selectedSessions;

        public CloseSessionOperation(List<Session> selectedSessions) {
            this.selectedSessions = selectedSessions;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            for (Session session : this.selectedSessions) {
                CloseSessionCommand command = new CloseSessionCommand(session);
                command.run();
            }
        }
    }
}

