/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.tools.api.query.IllegalStateExceptionQuery;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.EditionTableDescription;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.ui.runnable.OpenRepresentationsRunnable;

public class OpenRepresentationsAction
extends BaseSelectionListenerAction {
    private static final Logger LOGGER = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private DRepresentationDescriptor descriptor;

    public OpenRepresentationsAction() {
        super("Open");
    }

    public OpenRepresentationsAction(DRepresentationDescriptor descriptor) {
        super(descriptor.getName());
        this.descriptor = descriptor;
        RepresentationDescription description = descriptor.getDescription();
        ImageDescriptor imageDescriptor = null;
        imageDescriptor = description instanceof CrossTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/CrossTableDescription.gif") : (description instanceof EditionTableDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.table.ui", (String)"/icons/full/obj16/DTable.gif") : (description instanceof SequenceDiagramDescription ? AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.sequence.edit", (String)"/icons/full/obj16/TSequenceDiagram.gif") : AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sirius.diagram.ui", (String)"/icons/full/obj16/DDiagram.gif")));
        if (imageDescriptor == null) {
            imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        this.setImageDescriptor(imageDescriptor);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        try {
            return !this.getOpenableRepresentationDescriptors(selection).isEmpty();
        }
        catch (IllegalStateException e) {
            if (new IllegalStateExceptionQuery(e).isAConnectionLostException()) {
                return false;
            }
            throw e;
        }
    }

    private List<DRepresentationDescriptor> getOpenableRepresentationDescriptors(IStructuredSelection selection) {
        return RepresentationHelper.getSelectedDescriptors((Collection)selection.toList()).stream().filter(RepresentationHelper::isValid).collect(Collectors.toList());
    }

    public void run() {
        List<DRepresentationDescriptor> reps = this.descriptor != null ? Collections.singletonList(this.descriptor) : this.getOpenableRepresentationDescriptors(this.getStructuredSelection());
        if (reps.isEmpty()) {
            return;
        }
        String eventName = "Open Representation";
        String eventContext = "";
        String addendum = "";
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
        OpenRepresentationsRunnable runnable = new OpenRepresentationsRunnable(reps, false);
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
        try {
            progressDialog.run(false, false, (IRunnableWithProgress)runnable);
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
        }
        catch (InvocationTargetException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR, addendum);
        }
        catch (InterruptedException e) {
            LOGGER.debug((Object)new EmbeddedMessage(e.getMessage(), "User Interface"));
            UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.ERROR, addendum);
        }
    }
}

