/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.mdsofa.common.constant.ICommonConstants;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractDiagramCommandHandler;

public class CopyTextHandler
extends AbstractDiagramCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String text = this.getSelectionAsText();
        if (text != null) {
            Clipboard c = new Clipboard(HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getShell().getDisplay());
            Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
            Object[] data = new Object[]{text};
            c.setContents(data, transfers);
            c.dispose();
        }
        return null;
    }

    public String getSelectionAsText() {
        String result = null;
        IStructuredSelection selection = this.getSelection();
        if (!selection.isEmpty()) {
            result = Arrays.stream(selection.toArray()).map(CopyTextHandler::getLabel).collect(Collectors.joining(ICommonConstants.LINE_SEPARATOR));
        }
        return result;
    }

    private static String getLabel(Object o) {
        if (o instanceof ModelElement) {
            return ((ModelElement)o).getLabel();
        }
        if (o instanceof DRepresentationDescriptor) {
            return ((DRepresentationDescriptor)o).getName();
        }
        return o != null ? o.toString() : null;
    }

    @Override
    public boolean isEnabled() {
        return this.getSelection().size() != 0;
    }
}

