/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.DRepresentationDescriptorQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.eclipse.sirius.tools.api.command.ui.NoUICallback;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.util.IJobConstants;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.handlers.AbstractDiagramCommandHandler;
import org.polarsys.capella.core.sirius.ui.handlers.Messages;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class RefreshDiagramsCommandHandler
extends AbstractDiagramCommandHandler {
    protected Session getSession(Object object_p) {
        Session session = null;
        if (object_p instanceof IFile) {
            session = SessionHelper.getSessionForDiagramFile((IFile)object_p);
        } else if (object_p instanceof ModelElement) {
            session = SessionManager.INSTANCE.getSession((EObject)((ModelElement)object_p));
        }
        return session;
    }

    @Override
    public boolean isEnabled() {
        IStructuredSelection currentSelection = this.getSelection();
        if (currentSelection.isEmpty()) {
            return false;
        }
        Object selectedElement = currentSelection.getFirstElement();
        Session selectedElementSession = this.getSession(selectedElement);
        return selectedElementSession != null;
    }

    public Object execute(ExecutionEvent event_p) throws ExecutionException {
        Object selectedElement = this.getSelection().getFirstElement();
        Session session = this.getSession(selectedElement);
        this.refreshRepresentations(selectedElement, session);
        return null;
    }

    public Collection<DRepresentationDescriptor> getSubRepresentations(Object selectedElement, Session session) {
        Collection<Object> representationsToRefresh = Collections.emptyList();
        if (selectedElement instanceof ModelElement) {
            representationsToRefresh = new ArrayList();
            Collection allSessionRepresentations = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
            for (DRepresentationDescriptor representation : allSessionRepresentations) {
                EObject associatedModelElement = representation.getTarget();
                if (!EcoreUtil.isAncestor((EObject)((ModelElement)selectedElement), (EObject)associatedModelElement)) continue;
                representationsToRefresh.add(representation);
            }
        } else if (selectedElement instanceof IFile) {
            representationsToRefresh = DialectManager.INSTANCE.getAllRepresentationDescriptors(session);
        }
        return representationsToRefresh;
    }

    public Job refreshRepresentations(Object selectedElement, Session session) {
        Collection<DRepresentationDescriptor> representationDescriptors = this.getSubRepresentations(selectedElement, session);
        if (representationDescriptors.isEmpty()) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_9, (String)Messages.RefreshRepresentation_10);
        } else {
            if (session.getStatus() == SessionStatus.DIRTY) {
                if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_4, (String)Messages.RefreshRepresentation_5)) {
                    session.save((IProgressMonitor)new NullProgressMonitor());
                } else {
                    return null;
                }
            }
            if (MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.RefreshRepresentation_1, (String)Messages.bind((String)Messages.RefreshRepresentation_2, (Object)representationDescriptors.size()))) {
                IEditorReference[] openedEditorReferences;
                IEditorReference[] iEditorReferenceArray = openedEditorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = openedEditorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editor = editorReference.getEditor(false);
                    if (DialectUIManager.INSTANCE.canHandleEditor(editor)) {
                        DialectUIManager.INSTANCE.closeEditor(editor, false);
                    }
                    ++n2;
                }
                RefreshDiagramsJob job = new RefreshDiagramsJob(representationDescriptors, session, Display.getDefault());
                job.setUser(true);
                job.schedule();
                return job;
            }
        }
        return null;
    }

    protected class ClosingDiagramJob
    extends WorkspaceJob {
        private Display _display;
        private IEditorPart editor;

        public ClosingDiagramJob(String name, IEditorPart editor_p, Display display_p) {
            super(name);
            this.editor = editor_p;
            this._display = display_p;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            this._display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page;
                    IWorkbenchPartSite site;
                    if (ClosingDiagramJob.this.editor != null && (site = ClosingDiagramJob.this.editor.getSite()) != null && (page = site.getPage()) != null) {
                        page.closeEditor(ClosingDiagramJob.this.editor, false);
                    }
                }
            });
            return Status.OK_STATUS;
        }
    }

    protected class OpeningDiagramJob
    extends WorkspaceJob {
        private Session session;
        private DRepresentation dRepresentation;
        private IEditorPart currentEditor;

        public OpeningDiagramJob(String name, Session session, DRepresentation dRepresentation) {
            super(name);
            this.session = session;
            this.dRepresentation = dRepresentation;
            this.currentEditor = null;
        }

        public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
            if (this.session != null && this.dRepresentation != null) {
                this.currentEditor = DialectUIManager.INSTANCE.openEditor(this.session, this.dRepresentation, monitor);
            }
            if (this.currentEditor != null && ((DialectEditor)this.currentEditor).isLastRepresentationRefreshSucceeded().orElse(Boolean.FALSE).booleanValue()) {
                return Status.OK_STATUS;
            }
            return new Status(1, SiriusUIPlugin.getDefault().getPluginId(), "Failed to refresh the representation " + this.dRepresentation.getName());
        }

        public IEditorPart getCurrentEditor() {
            return this.currentEditor;
        }
    }

    public class RefreshDiagramsJob
    extends WorkspaceJob {
        private Session session;
        private Collection<DRepresentationDescriptor> representationsDescriptorsToRefresh;
        private Display display;
        private UICallBack uiCallback;

        public RefreshDiagramsJob(Collection<DRepresentationDescriptor> representations, final Session session, Display display) {
            super(Messages.RefreshRepresentation_0);
            this.setProperty(IJobConstants.ALWAYS_LOG_STATUS, true);
            this.session = session;
            this.representationsDescriptorsToRefresh = representations;
            this.display = display;
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
                Boolean currentValueOfSiriusPrefRefreshOnOpening;

                public void running(IJobChangeEvent event) {
                    if (session.getSiriusPreferences().hasSpecificSettingRefreshOnRepresentationOpening()) {
                        this.currentValueOfSiriusPrefRefreshOnOpening = session.getSiriusPreferences().isRefreshOnRepresentationOpening();
                    }
                    session.getSiriusPreferences().setRefreshOnRepresentationOpening(true);
                    RefreshDiagramsJob.this.uiCallback = SiriusEditPlugin.getPlugin().getUiCallback();
                    SiriusEditPlugin.getPlugin().setUiCallback((UICallBack)new NoUICallback());
                }

                public void done(IJobChangeEvent event) {
                    if (this.currentValueOfSiriusPrefRefreshOnOpening == null) {
                        session.getSiriusPreferences().unsetRefreshOnRepresentationOpening();
                    } else {
                        session.getSiriusPreferences().setRefreshOnRepresentationOpening(this.currentValueOfSiriusPrefRefreshOnOpening.booleanValue());
                    }
                    SiriusEditPlugin.getPlugin().setUiCallback(RefreshDiagramsJob.this.uiCallback);
                }
            });
        }

        public IStatus runInWorkspace(IProgressMonitor monitor_p) throws CoreException {
            int repToRefreshNb = this.representationsDescriptorsToRefresh.size();
            ArrayList<DRepresentationDescriptor> representationWithOtherErrors = new ArrayList<DRepresentationDescriptor>();
            ArrayList<DRepresentationDescriptor> representationNotLoadable = new ArrayList<DRepresentationDescriptor>();
            ArrayList<DRepresentationDescriptor> representationDangling = new ArrayList<DRepresentationDescriptor>();
            monitor_p.beginTask(this.getName(), repToRefreshNb);
            if (this.session != null) {
                int counter = 0;
                for (DRepresentationDescriptor dRepresentationDesc : this.representationsDescriptorsToRefresh) {
                    monitor_p.subTask(Messages.bind((String)Messages.RefreshRepresentation_6, (Object[])new Object[]{dRepresentationDesc.getName(), ++counter, repToRefreshNb}));
                    DRepresentation representation = dRepresentationDesc.getRepresentation();
                    if (representation != null) {
                        if (new DRepresentationDescriptorQuery(dRepresentationDesc).isRepresentationValid()) {
                            OpeningDiagramJob job_opening = new OpeningDiagramJob(Messages.RefreshRepresentation_7, this.session, representation);
                            job_opening.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, Boolean.TRUE);
                            job_opening.setUser(false);
                            job_opening.schedule();
                            try {
                                job_opening.join();
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                            if (job_opening.getResult().isOK()) {
                                ClosingDiagramJob job_closing = new ClosingDiagramJob(Messages.RefreshRepresentation_8, job_opening.getCurrentEditor(), this.display);
                                job_closing.setUser(false);
                                job_closing.schedule();
                                try {
                                    job_closing.join();
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            } else {
                                representationWithOtherErrors.add(dRepresentationDesc);
                            }
                        } else {
                            representationDangling.add(dRepresentationDesc);
                        }
                    } else {
                        representationNotLoadable.add(dRepresentationDesc);
                    }
                    monitor_p.worked(1);
                    if (monitor_p.isCanceled()) break;
                }
            }
            monitor_p.done();
            int nbRefreshWithError = representationNotLoadable.size() + representationDangling.size() + representationWithOtherErrors.size();
            int nbRefreshWithSuccess = repToRefreshNb - nbRefreshWithError;
            StringBuilder strBuilder = new StringBuilder();
            if (nbRefreshWithSuccess > 1) {
                strBuilder.append(String.valueOf(nbRefreshWithSuccess) + " representations refreshed");
            } else {
                strBuilder.append(String.valueOf(nbRefreshWithSuccess) + " representation refreshed");
            }
            int severity = 0;
            if (nbRefreshWithError > 0) {
                severity = 2;
                strBuilder.append(" and " + nbRefreshWithError + " representation(s) failed to refresh");
                if (representationNotLoadable.size() > 0) {
                    strBuilder.append("\nNot loadable representation(s) (invalid)");
                    representationNotLoadable.stream().forEach(repDesc -> {
                        String repDescInfo = this.addRepDescInfo(strBuilder, (DRepresentationDescriptor)repDesc);
                        Logger.getLogger((String)"Diagrams Management").error((Object)new EmbeddedMessage("The representation can not be loaded (invalid): " + repDescInfo, "", Collections.singletonList(repDesc)));
                    });
                }
                if (representationDangling.size() > 0) {
                    strBuilder.append("\nRepresentation(s) with no valid semantic target (invalid)");
                    representationDangling.stream().forEach(repDesc -> {
                        String repDescInfo = this.addRepDescInfo(strBuilder, (DRepresentationDescriptor)repDesc);
                        Logger.getLogger((String)"Diagrams Management").error((Object)new EmbeddedMessage("The representation has no valid semantic target (invalid): " + repDescInfo, "", Collections.singletonList(repDesc)));
                    });
                }
                if (representationWithOtherErrors.size() > 0) {
                    strBuilder.append("\nRepresentation(s) that failed to refresh");
                    representationWithOtherErrors.stream().forEach(repDesc -> {
                        String repDescInfo = this.addRepDescInfo(strBuilder, (DRepresentationDescriptor)repDesc);
                        Logger.getLogger((String)"Diagrams Management").warn((Object)new EmbeddedMessage("The representation failed to refresh: " + repDescInfo, "", Collections.singletonList(repDesc)));
                    });
                }
            }
            return new Status(severity, SiriusUIPlugin.getDefault().getPluginId(), strBuilder.toString());
        }

        private String addRepDescInfo(StringBuilder strBuilder, DRepresentationDescriptor repDesc) {
            String repDescInfo = this.getRepDescInfo(repDesc);
            strBuilder.append("\n - ");
            strBuilder.append(repDescInfo);
            return repDescInfo;
        }

        private String getRepDescInfo(DRepresentationDescriptor repDesc) {
            StringBuilder strBuilder = new StringBuilder();
            strBuilder.append("name: " + repDesc.getName());
            strBuilder.append(", uid: " + repDesc.getUid());
            if (repDesc.getTarget() instanceof ModelElement) {
                strBuilder.append(", target: " + ((ModelElement)repDesc.getTarget()).getLabel());
            }
            return strBuilder.toString();
        }
    }
}

