/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.common.mdsofa.common.helper.ProjectHelper;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.model.label.LabelRetriever;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.Messages;

public class ControlResourceDialog
extends ResourceDialog {
    protected EditingDomain _domain;
    protected Resource _resource;
    protected Resource _currentResource;
    protected EObject _controledObject;
    private String[] XMLEscapeCharacters = new String[]{"\"", "'", "<", ">", "&"};

    public ControlResourceDialog(Shell parent_p, EditingDomain domain_p, Resource currentResource_p, EObject controledObject) {
        super(parent_p, Messages.ControlAction_Window_Title, 8192);
        this._domain = domain_p;
        this._currentResource = currentResource_p;
        this._controledObject = controledObject;
    }

    protected Control doCreateDialogArea(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        ControlResourceDialog.applyDialogFont((Control)composite);
        Label resourceURILabel = new Label(composite, 0);
        resourceURILabel.setText(Messages.ControlAction_Label_Title);
        resourceURILabel.setLayoutData((Object)new GridData(32));
        this.uriField = new Text(composite, 2052);
        this.uriField.setLayoutData((Object)new GridData(768));
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = this.doCreateDialogArea(parent);
        String defaultUri = this.computeFragmentUri();
        this.uriField.setText(URI.encodeFragment((String)defaultUri, (boolean)true));
        return control;
    }

    protected String computeFragmentUri() {
        StringBuilder defaultURI = new StringBuilder();
        URI fragmentFolderUri = this._controledObject.eResource().getURI().trimSegments(1);
        if (!"fragments".equals(fragmentFolderUri.lastSegment())) {
            fragmentFolderUri = fragmentFolderUri.appendSegment("fragments");
        }
        defaultURI.append(URI.decode((String)fragmentFolderUri.toString()));
        defaultURI.append('/');
        ModelElement controlledModelElement = (ModelElement)this._controledObject;
        Path fullObjectPath = new Path(this.getFullLabel(controlledModelElement));
        fullObjectPath = fullObjectPath.removeFirstSegments(2);
        String analyisName = fullObjectPath.segment(0);
        if (analyisName != null) {
            fullObjectPath = fullObjectPath.removeFirstSegments(1);
            Path fragmentRelativePath = new Path(this.getCamelCaseRepresentation(analyisName));
            String[] stringArray = fullObjectPath.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment;
                String appendedSegment = segment = stringArray[n2];
                if (segment.matches("(Root\\s).*(\\sFunction)")) {
                    appendedSegment = this.getCamelCaseRepresentation(segment);
                }
                fragmentRelativePath = fragmentRelativePath.append(appendedSegment);
                ++n2;
            }
            String fragmentRelative = fragmentRelativePath.toString();
            fragmentRelative = fragmentRelative.replace('/', '-');
            defaultURI.append(fragmentRelative);
            defaultURI.append('.');
            defaultURI.append("capellafragment");
        }
        return defaultURI.toString();
    }

    private String getFullLabel(ModelElement object_p) {
        String result = String.valueOf(ControlResourceDialog.getFullPath((EObject)object_p)) + ControlResourceDialog.getLabel((EObject)object_p);
        return result;
    }

    public static String getFullPath(EObject object_p) {
        EObject eContainer = object_p.eContainer();
        if (eContainer == object_p) {
            return "";
        }
        String result = eContainer != null ? String.valueOf(ControlResourceDialog.getFullPath(eContainer)) + ControlResourceDialog.getLabel(eContainer) + '/' : Character.toString('/');
        return result;
    }

    public static String getLabel(EObject object_p) {
        StringBuilder result = new StringBuilder();
        char[] cArray = LabelRetriever.getLabel((EObject)object_p).toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char car = cArray[n2];
            if (Character.isJavaIdentifierPart(car) || Character.isWhitespace(car)) {
                result.append(car);
            }
            ++n2;
        }
        return result.toString();
    }

    private String getCamelCaseRepresentation(String word_p) {
        StringBuilder camelCaseAnalysisLevel = new StringBuilder();
        char[] cArray = word_p.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char currentCharacter = cArray[n2];
            if (Character.isUpperCase(currentCharacter)) {
                camelCaseAnalysisLevel.append(currentCharacter);
            }
            ++n2;
        }
        return camelCaseAnalysisLevel.length() == 0 ? word_p : camelCaseAnalysisLevel.toString();
    }

    private List<String> getInvalidCharacters() {
        ArrayList<String> invalidCharacters = new ArrayList<String>();
        String OSName = System.getProperty("os.name");
        if (OSName.toLowerCase().startsWith("win")) {
            invalidCharacters.addAll(Arrays.asList("\\", "/", ":", "*", "?", "\"", "<", ">", "|"));
        } else if (OSName.toLowerCase().startsWith("mac")) {
            invalidCharacters.addAll(Arrays.asList("/", ":"));
        } else {
            invalidCharacters.addAll(Arrays.asList("/"));
        }
        String[] stringArray = this.XMLEscapeCharacters;
        int n = this.XMLEscapeCharacters.length;
        int n2 = 0;
        while (n2 < n) {
            String character = stringArray[n2];
            if (!invalidCharacters.contains(character)) {
                invalidCharacters.add(character);
            }
            ++n2;
        }
        return invalidCharacters;
    }

    protected boolean processResources() {
        boolean resourceInSet;
        String formattedMessage;
        List uris = this.getURIs();
        if (uris.isEmpty()) {
            return false;
        }
        URI uri = (URI)uris.get(0);
        String file = uri.lastSegment();
        for (String character : this.getInvalidCharacters()) {
            if (!file.contains(character)) continue;
            String formattedMessage2 = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error3_Message, (Object[])new String[]{!character.equals("&") ? character : "&&"});
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage2);
            return false;
        }
        if (!CapellaResourceHelper.isCapellaFragment((URI)uri) || uri.lastSegment().equals(".capellafragment")) {
            formattedMessage = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error_Message, (Object[])new String[]{".capellafragment"});
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage);
            return false;
        }
        if (!uri.isPlatformResource()) {
            formattedMessage = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error4_Message, (Object[])new String[]{uri.toString()});
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage);
            return false;
        }
        if (!this.projectExists(uri)) {
            formattedMessage = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error5_Message, (Object[])new String[]{uri.toString()});
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage);
            return false;
        }
        if (FileHelper.getPlatformFile((String)uri.toPlatformString(true)).exists()) {
            formattedMessage = StringHelper.formatMessage((String)Messages.ControlAction_Fragmentation_Error2_Message, (Object[])new String[]{uri.toPlatformString(true)});
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ControlAction_Window_Title, (String)formattedMessage);
            return false;
        }
        ResourceSet resourceSet = this._domain.getResourceSet();
        Resource theResource = resourceSet.getResource(uri, false);
        boolean bl = resourceInSet = theResource != null;
        if (theResource == this._currentResource) {
            MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AlreadyInResource"));
            return false;
        }
        if (this._domain.isReadOnly(theResource)) {
            MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReadOnlyResource"));
            return false;
        }
        boolean resourceExists = false;
        try {
            InputStream stream = resourceSet.getURIConverter().createInputStream(uri);
            if (stream != null) {
                resourceExists = true;
                stream.close();
            }
        }
        catch (IOException stream) {
            // empty catch block
        }
        boolean resourceBad = false;
        if (!resourceInSet) {
            theResource = resourceSet.createResource(uri);
            if (theResource == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_InvalidURI_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_CannotCreateResource"));
                return false;
            }
            if (resourceExists) {
                try {
                    theResource = resourceSet.getResource(uri, true);
                }
                catch (RuntimeException exception) {
                    EMFEditUIPlugin.INSTANCE.log((Object)exception);
                    resourceBad = theResource.getContents().isEmpty();
                }
            }
        }
        boolean result = true;
        if (resourceBad) {
            result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_ReplaceResource"));
        } else if (resourceExists) {
            result = MessageDialog.openQuestion((Shell)this.getShell(), (String)EMFEditUIPlugin.INSTANCE.getString("_UI_ExistingResource_label"), (String)EMFEditUIPlugin.INSTANCE.getString("_WARN_AddToResource"));
        }
        if (!result && !resourceInSet && theResource != null) {
            theResource.unload();
            resourceSet.getResources().remove((Object)theResource);
        } else {
            this._resource = theResource;
        }
        return result;
    }

    private boolean projectExists(URI platformResourceUri) {
        if (!platformResourceUri.isPlatformResource() || platformResourceUri.segmentCount() <= 1) {
            return false;
        }
        String projectName = platformResourceUri.segment(1);
        IProject project = ProjectHelper.getProject((String)(projectName = URI.decode((String)projectName)));
        return project != null && project.exists();
    }

    public Resource getResource() {
        return this._resource;
    }
}

