/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.listener;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class DAnnotationChangeTrigger
implements ModelChangeTrigger {
    private Session session;

    public DAnnotationChangeTrigger(Session session) {
        this.session = session;
    }

    public Option<Command> localChangesAboutToCommit(Collection<Notification> notifications) {
        LinkedHashSet<DRepresentation> representationsToRefresh = this.collectRepresentationsToRefresh(notifications);
        return Options.newSome((Object)new RefreshRepresentationsCommand(this.session.getTransactionalEditingDomain(), (IProgressMonitor)new NullProgressMonitor(), representationsToRefresh));
    }

    protected LinkedHashSet<DRepresentation> collectRepresentationsToRefresh(Collection<Notification> notifications) {
        LinkedHashSet representationsToRefresh = Sets.newLinkedHashSet();
        for (Notification notification : notifications) {
            Option<DRepresentation> representationOption;
            if (!(notification.getNotifier() instanceof EObject) || !(representationOption = this.getParentRepresentation((EObject)notification.getNotifier())).some()) continue;
            representationsToRefresh.add((DRepresentation)representationOption.get());
        }
        return representationsToRefresh;
    }

    private Option<DRepresentation> getParentRepresentation(EObject eObject) {
        EObject current = eObject;
        while (current != null) {
            if (current instanceof DRepresentationDescriptor && ((DRepresentationDescriptor)current).isLoadedRepresentation()) {
                current = ((DRepresentationDescriptor)current).getRepresentation();
            }
            if (current instanceof DRepresentation) {
                return Options.newSome((Object)((DRepresentation)current));
            }
            current = current.eContainer();
        }
        return Options.newNone();
    }

    public int priority() {
        return 0;
    }
}

