/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.Collection;
import java.util.Collections;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;

public class FunctionAllocator {
    private final Collection<AbstractFunction> allocations;

    private FunctionAllocator(Collection<AbstractFunction> eia) {
        this.allocations = eia;
    }

    public FunctionAllocator on(Component c) {
        for (AbstractFunction f : this.allocations) {
            if (!f.getAllocationBlocks().isEmpty()) continue;
            ComponentFunctionalAllocation cfa = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
            cfa.setSourceElement((TraceableElement)c);
            cfa.setTargetElement((TraceableElement)f);
            c.getOwnedFunctionalAllocation().add((Object)cfa);
        }
        return this;
    }

    public static FunctionAllocator allocate(AbstractFunction f) {
        return FunctionAllocator.allocate(Collections.singleton(f));
    }

    public static FunctionAllocator allocate(Collection<AbstractFunction> functions) {
        return new FunctionAllocator(functions);
    }
}

