/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.menu.dynamic.CreationHelper;
import org.polarsys.capella.common.utils.graph.IDirectedGraph;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalChainContainer;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.FunctionalChainAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.Messages;
import org.polarsys.capella.core.model.helpers.graph.InvolvementHierarchyGraph;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;

public class FunctionalChainExt {
    static String PLUGIN_ID = "org.polarsys.capella.core.model.helpers";

    public static boolean isFirstFunctionalChainInvolvement(FunctionalChainInvolvement involment) {
        return involment.getInvolved() != null && involment.getPreviousFunctionalChainInvolvements().isEmpty();
    }

    public static boolean isLastFunctionalChainInvolvement(FunctionalChainInvolvement involment) {
        return involment.getInvolved() != null && involment.getNextFunctionalChainInvolvements().isEmpty();
    }

    public static Collection<AbstractExchangeItem> getInvalidExchangeItems(FunctionalChainInvolvementLink involvement) {
        if (involvement.getInvolved() instanceof FunctionalExchange) {
            FunctionalExchange exchange = (FunctionalExchange)involvement.getInvolved();
            HashSet<AbstractExchangeItem> involvementExchangeItems = new HashSet<AbstractExchangeItem>((Collection<AbstractExchangeItem>)involvement.getExchangedItems());
            EList exchangeExchangedItems = exchange.getExchangedItems();
            involvementExchangeItems.removeAll((Collection<?>)exchangeExchangedItems);
            return involvementExchangeItems;
        }
        return Collections.emptySet();
    }

    public static Set<AbstractFunction> getFunctionalChainFirstFunctions(FunctionalChain functionalChain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : functionalChain.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(inv) || !(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatFirstFunctionalChainInvolvments(FunctionalChain functionalChain) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(involvement)) continue;
                if (involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static Set<AbstractFunction> getFlatFunctionalChainFirstFunctions(FunctionalChain chain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatFirstFunctionalChainInvolvments(chain)) {
            if (!(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Set<AbstractFunction> getFunctionalChainLastFunctions(FunctionalChain functionalChain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : functionalChain.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isLastFunctionalChainInvolvement(inv) || !(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatLastFunctionalChainInvolvments(FunctionalChain functionalChain1) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain1);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (!FunctionalChainExt.isLastFunctionalChainInvolvement(involvement)) continue;
                if (involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                    continue;
                }
                result.add(involvement);
            }
        }
        return result;
    }

    public static Set<AbstractFunction> getFlatFunctionalChainLastFunctions(FunctionalChain chain) {
        HashSet<AbstractFunction> result = new HashSet<AbstractFunction>();
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatLastFunctionalChainInvolvments(chain)) {
            if (!(inv.getInvolved() instanceof AbstractFunction)) continue;
            result.add((AbstractFunction)inv.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getPreviousExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChainInvolvement> toVisit = new LinkedList<FunctionalChainInvolvement>();
        HashSet<FunctionalChainInvolvement> visited = new HashSet<FunctionalChainInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            FunctionalChainInvolvement involvment = (FunctionalChainInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (FunctionalChainInvolvement aPreviousInv : involvment.getPreviousFunctionalChainInvolvements()) {
                if (aPreviousInv.getInvolved() == null) continue;
                if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatPreviousExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement aPreviousInv : FunctionalChainExt.getFlatPreviousFunctionalChainInvolvements(involvement)) {
            if (aPreviousInv.getInvolved() == null) continue;
            if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                result.add(aPreviousInv);
                continue;
            }
            for (FunctionalChainInvolvement aaanv : FunctionalChainExt.getFlatPreviousFunctionalChainInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolved() instanceof FunctionalExchange)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getNextExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        LinkedList<FunctionalChainInvolvement> toVisit = new LinkedList<FunctionalChainInvolvement>();
        HashSet<FunctionalChainInvolvement> visited = new HashSet<FunctionalChainInvolvement>();
        toVisit.add(involvement);
        while (!toVisit.isEmpty()) {
            FunctionalChainInvolvement involvment = (FunctionalChainInvolvement)toVisit.removeFirst();
            if (visited.contains(involvment)) continue;
            visited.add(involvment);
            for (FunctionalChainInvolvement aPreviousInv : involvment.getNextFunctionalChainInvolvements()) {
                if (aPreviousInv.getInvolved() == null) continue;
                if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                    result.add(aPreviousInv);
                    continue;
                }
                toVisit.add(aPreviousInv);
            }
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatNextExchangeInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement aPreviousInv : FunctionalChainExt.getFlatNextFunctionalChainInvolvements(involvement)) {
            if (aPreviousInv.getInvolved() == null) continue;
            if (aPreviousInv.getInvolved() instanceof FunctionalExchange) {
                result.add(aPreviousInv);
                continue;
            }
            for (FunctionalChainInvolvement aaanv : FunctionalChainExt.getFlatNextFunctionalChainInvolvements(aPreviousInv)) {
                if (!(aaanv.getInvolved() instanceof FunctionalExchange)) continue;
                result.add(aaanv);
            }
        }
        return result;
    }

    public static List<FunctionalChainInvolvement> getFirstFunctionalChainInvolvements(FunctionalChain element) {
        ArrayList<FunctionalChainInvolvement> ret = new ArrayList<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement inv : element.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isFirstFunctionalChainInvolvement(inv)) continue;
            ret.add(inv);
        }
        return ret;
    }

    public static List<FunctionalChainInvolvement> getLastFunctionalChainInvolvements(FunctionalChain element) {
        ArrayList<FunctionalChainInvolvement> ret = new ArrayList<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement inv : element.getOwnedFunctionalChainInvolvements()) {
            if (!FunctionalChainExt.isLastFunctionalChainInvolvement(inv)) continue;
            ret.add(inv);
        }
        return ret;
    }

    public static Set<FunctionalChainInvolvement> getFlatPreviousFunctionalChainInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement in : involvement.getPreviousFunctionalChainInvolvements()) {
            if (in.getInvolved() instanceof FunctionalChain) {
                result.addAll(FunctionalChainExt.getFlatLastFunctionalChainInvolvments((FunctionalChain)in.getInvolved()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatNextFunctionalChainInvolvements(FunctionalChainInvolvement involvement) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement in : involvement.getNextFunctionalChainInvolvements()) {
            if (in.getInvolved() instanceof FunctionalChain) {
                result.addAll(FunctionalChainExt.getFlatFirstFunctionalChainInvolvments((FunctionalChain)in.getInvolved()));
                continue;
            }
            result.add(in);
        }
        return result;
    }

    public static List<List<FunctionalChainInvolvement>> getFirstFlatHierachicalContexts(FunctionalChainReference fcr) {
        ArrayList<FunctionalChainReference> hierarchicalContext = new ArrayList<FunctionalChainReference>();
        hierarchicalContext.add(fcr);
        List<List<FunctionalChainInvolvement>> allHierarchicalContexts = FunctionalChainExt.getFlatHierachicalContexts(fcr, hierarchicalContext);
        return allHierarchicalContexts.stream().filter(fciCollection -> FunctionalChainExt.isFirstFunctionalChainInvolvement((FunctionalChainInvolvement)fciCollection.get(0))).collect(Collectors.toList());
    }

    public static List<List<FunctionalChainInvolvement>> getLastFlatHierachicalContexts(FunctionalChainReference fcr) {
        ArrayList<FunctionalChainReference> hierarchicalContext = new ArrayList<FunctionalChainReference>();
        hierarchicalContext.add(fcr);
        List<List<FunctionalChainInvolvement>> allHierarchicalContexts = FunctionalChainExt.getFlatHierachicalContexts(fcr, hierarchicalContext);
        return allHierarchicalContexts.stream().filter(fciCollection -> FunctionalChainExt.isLastFunctionalChainInvolvement((FunctionalChainInvolvement)fciCollection.get(0))).collect(Collectors.toList());
    }

    public static List<List<FunctionalChainInvolvement>> getFlatHierachicalContexts(FunctionalChainReference fcr, List<FunctionalChainReference> currentContext) {
        ArrayList<List<FunctionalChainInvolvement>> allHierarchicalContexts = new ArrayList<List<FunctionalChainInvolvement>>();
        InvolvedElement involved = fcr.getInvolved();
        if (involved instanceof FunctionalChain) {
            FunctionalChain functionalChain = (FunctionalChain)involved;
            for (FunctionalChainInvolvement involvement : functionalChain.getInvolvedFunctionalChainInvolvements()) {
                if (involvement instanceof FunctionalChainInvolvementFunction) {
                    ArrayList<Object> fciAndHierarchicalContext = new ArrayList<Object>();
                    fciAndHierarchicalContext.add(involvement);
                    fciAndHierarchicalContext.addAll(currentContext);
                    allHierarchicalContexts.add(fciAndHierarchicalContext);
                    continue;
                }
                if (!(involvement instanceof FunctionalChainReference)) continue;
                ArrayList<FunctionalChainReference> childContext = new ArrayList<FunctionalChainReference>();
                childContext.add((FunctionalChainReference)involvement);
                childContext.addAll(currentContext);
                allHierarchicalContexts.addAll(FunctionalChainExt.getFlatHierachicalContexts((FunctionalChainReference)involvement, childContext));
            }
        }
        return allHierarchicalContexts;
    }

    public static boolean isFunctionalChainValid(FunctionalChain chain) {
        return FunctionalChainExt.isFunctionalChainWellFormed(chain) && !FunctionalChainExt.containsACycle(chain);
    }

    public static boolean isFunctionalChainWellFormed(FunctionalChain chain) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (chain.getOwnedFunctionalChainInvolvements().isEmpty()) {
            return false;
        }
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvements(chain)) {
            if (!FunctionalChainExt.isFunctionalChainInvolvementValid(involvement)) {
                return false;
            }
            if (!(involvement instanceof FunctionalChainInvolvementLink) || !(involvement.getInvolved() instanceof FunctionalExchange)) continue;
            FunctionalExchange currentExchange = (FunctionalExchange)involvement.getInvolved();
            graph.addNode((Object)FunctionExt.getIncomingAbstractFunction((FunctionalExchange)currentExchange), (Object)FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)currentExchange));
        }
        if (graph.isEmpty()) {
            return false;
        }
        return graph.isAConnectedGraph();
    }

    public static Collection<FunctionalExchange> getFlatIncomingExchanges(FunctionalChainInvolvement element) {
        HashSet<AbstractFunction> targetFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> targetExchanges = new HashSet<FunctionalExchange>();
        InvolvedElement involvedElement = element.getInvolved();
        if (involvedElement instanceof FunctionalExchange) {
            targetExchanges.add((FunctionalExchange)involvedElement);
        } else if (involvedElement instanceof AbstractFunction) {
            targetFunctions.add((AbstractFunction)involvedElement);
        } else if (involvedElement instanceof FunctionalChain) {
            targetFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainFirstFunctions((FunctionalChain)involvedElement));
        }
        for (AbstractFunction function : targetFunctions) {
            targetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        }
        return targetExchanges;
    }

    public static Collection<FunctionalExchange> getFlatOutgoingExchanges(FunctionalChainInvolvement element) {
        HashSet<AbstractFunction> sourceFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> sourceExchanges = new HashSet<FunctionalExchange>();
        InvolvedElement involvedElement = element.getInvolved();
        if (involvedElement instanceof FunctionalExchange) {
            sourceExchanges.add((FunctionalExchange)involvedElement);
        } else if (involvedElement instanceof AbstractFunction) {
            sourceFunctions.add((AbstractFunction)involvedElement);
        } else if (involvedElement instanceof FunctionalChain) {
            sourceFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainLastFunctions((FunctionalChain)involvedElement));
        }
        for (AbstractFunction function : sourceFunctions) {
            sourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
        }
        return sourceExchanges;
    }

    public static Collection<FunctionalExchange> getFlatCommonFunctionalExchanges(FunctionalChainInvolvement source, FunctionalChainInvolvement target) {
        Collection<FunctionalExchange> sourceExchanges = FunctionalChainExt.getFlatOutgoingExchanges(source);
        Collection<FunctionalExchange> targetExchanges = FunctionalChainExt.getFlatIncomingExchanges(target);
        sourceExchanges.retainAll(targetExchanges);
        return sourceExchanges;
    }

    public static Collection<FunctionalExchange> getFlatIncomingExchanges(FunctionalChain element) {
        HashSet<AbstractFunction> targetFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> targetExchanges = new HashSet<FunctionalExchange>();
        targetFunctions.addAll(FunctionalChainExt.getFlatFunctionalChainFirstFunctions(element));
        for (AbstractFunction function : targetFunctions) {
            targetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        }
        return targetExchanges;
    }

    public static IStatus getFunctionalChainInvolvementValidityStatus(FunctionalChainInvolvement involvement) {
        InvolvedElement involved = involvement.getInvolved();
        if (involved == null) {
            return new Status(4, PLUGIN_ID, Messages.Involvement_InvolvedNull);
        }
        InvolverElement involver = involvement.getInvolver();
        if (involver == null) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainExt_InvolverNull);
        }
        if (!involvement.eContainer().equals(involver)) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainExt_InvolverNotContainer);
        }
        if (involvement instanceof FunctionalChainReference) {
            return FunctionalChainExt.getFunctionalChainReferenceValidity((FunctionalChainReference)involvement);
        }
        if (involvement instanceof FunctionalChainInvolvementLink) {
            return FunctionalChainExt.getFunctionalChainInvolvementLinkValidity((FunctionalChainInvolvementLink)involvement);
        }
        if (involvement instanceof FunctionalChainInvolvementFunction) {
            return FunctionalChainExt.getFunctionalChainInvolvementFunctionValidity((FunctionalChainInvolvementFunction)involvement);
        }
        return Status.OK_STATUS;
    }

    private static IStatus getFunctionalChainReferenceValidity(FunctionalChainReference reference) {
        boolean isOperationalLevel = CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)reference);
        String functionalChainType = isOperationalLevel ? Messages.FunctionalChainExt_OperationalProcess : Messages.FunctionalChainExt_FunctionalChain;
        String functionalChainLabel = String.valueOf(isOperationalLevel ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + functionalChainType;
        InvolvedElement involved = reference.getInvolved();
        if (!(involved instanceof FunctionalChain)) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNot, (Object)functionalChainLabel));
        }
        return Status.OK_STATUS;
    }

    private static IStatus getFunctionalChainInvolvementLinkValidity(FunctionalChainInvolvementLink link) {
        boolean isOperationalLevel = CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)link);
        String functionType = isOperationalLevel ? Messages.FunctionalChainExt_OperationalActivity : Messages.FunctionalChainExt_Function;
        String exchangeType = isOperationalLevel ? Messages.FunctionalChainExt_Interaction : Messages.FunctionalChainExt_FunctionalExchange;
        String functionLabel = String.valueOf(isOperationalLevel ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + functionType;
        String exchangeLabel = String.valueOf(isOperationalLevel ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + exchangeType;
        InvolvedElement involved = link.getInvolved();
        if (!(involved instanceof FunctionalExchange) && !(involved instanceof AbstractFunction)) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNotAndNot, (Object)exchangeLabel, (Object)functionLabel));
        }
        if (link.getSource() == null) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainInvLink_SourceNull);
        }
        if (link.getTarget() == null) {
            return new Status(4, PLUGIN_ID, Messages.FunctionalChainInvLink_TargetNull);
        }
        for (FunctionalChainInvolvement nextInvolvement : link.getNextFunctionalChainInvolvements()) {
            if (!(nextInvolvement instanceof FunctionalChainInvolvementFunction)) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsButNextIsNotA, (Object)exchangeLabel, (Object)functionLabel));
            }
            FunctionalChainInvolvementFunction nextInvolvementFunction = (FunctionalChainInvolvementFunction)nextInvolvement;
            InvolvedElement nextInvolved = nextInvolvementFunction.getInvolved();
            if (involved instanceof FunctionalExchange && nextInvolved != FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)involved))) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToSourceNext, (Object)exchangeLabel, (Object)functionType));
            }
            if (!(involved instanceof AbstractFunction) || involved == nextInvolved) continue;
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToSourceNext, (Object)functionLabel, (Object)functionType));
        }
        return Status.OK_STATUS;
    }

    private static IStatus getFunctionalChainInvolvementFunctionValidity(FunctionalChainInvolvementFunction involvementFunction) {
        boolean isOperationalLevel = CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)involvementFunction);
        String functionType = isOperationalLevel ? Messages.FunctionalChainExt_OperationalActivity : Messages.FunctionalChainExt_Function;
        String exchangeType = isOperationalLevel ? Messages.FunctionalChainExt_Interaction : Messages.FunctionalChainExt_FunctionalExchange;
        String functionLabel = String.valueOf(isOperationalLevel ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + functionType;
        String exchangeLabel = String.valueOf(isOperationalLevel ? Messages.FunctionalChainExt_an : Messages.FunctionalChainExt_a) + exchangeType;
        InvolvedElement involved = involvementFunction.getInvolved();
        if (!(involved instanceof AbstractFunction)) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvedElementNot, (Object)functionLabel));
        }
        if (involvementFunction.getIncomingInvolvementLinks().isEmpty() && involvementFunction.getOutgoingInvolvementLinks().isEmpty()) {
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_InvolvementAlone, (Object)functionLabel));
        }
        for (FunctionalChainInvolvement nextInvolvement : involvementFunction.getNextFunctionalChainInvolvements()) {
            FunctionalExchange nextExchange;
            if (!(nextInvolvement instanceof FunctionalChainInvolvementLink)) {
                return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsButNextIsNotA, (Object)functionLabel, (Object)exchangeLabel));
            }
            FunctionalChainInvolvementLink nextLink = (FunctionalChainInvolvementLink)nextInvolvement;
            if (!(nextLink.getInvolved() instanceof FunctionalExchange ? involved != FunctionExt.getIncomingAbstractFunction((FunctionalExchange)(nextExchange = (FunctionalExchange)nextLink.getInvolved())) : nextLink.getInvolved() instanceof AbstractFunction && involved != nextLink.getInvolved())) continue;
            return new Status(4, PLUGIN_ID, NLS.bind((String)Messages.FunctionalChainExt_IsNotRelatedToSourceNext, (Object)functionLabel, (Object)exchangeType));
        }
        return Status.OK_STATUS;
    }

    public static boolean isFunctionalChainInvolvementValid(FunctionalChainInvolvement inv) {
        return FunctionalChainExt.getFunctionalChainInvolvementValidityStatus(inv).isOK();
    }

    public static boolean containsACycle(FunctionalChainInvolvement involvement) {
        if (involvement.getInvolved() instanceof FunctionalChain) {
            FunctionalChain fc = (FunctionalChain)involvement.getInvolved();
            return FunctionalChainExt.containsACycle(fc);
        }
        return false;
    }

    public static boolean containsACycle(FunctionalChain functionalChain) {
        return new InvolvementHierarchyGraph(functionalChain).hasCycle();
    }

    public static FunctionalChain createFunctionalChain(AbstractFunctionalChainContainer container, Collection<EObject> involvedElements) {
        TransactionalEditingDomain editingDomain;
        StrictCompoundCommand command;
        Object newFC = BlockArchitectureExt.getRootBlockArchitecture((EObject)container) instanceof OperationalAnalysis ? OaFactory.eINSTANCE.createOperationalProcess() : FaFactory.eINSTANCE.createFunctionalChain();
        container.getOwnedFunctionalChains().add(newFC);
        if (container instanceof AbstractCapability) {
            FunctionalChainExt.createFunctionalChainAbstractCapabilityInvolvement((AbstractCapability)container, (FunctionalChain)newFC);
        }
        if ((command = CreationHelper.getAdditionnalCommand((EditingDomain)(editingDomain = TransactionHelper.getEditingDomain((EObject)newFC)), (ModelElement)newFC)).canExecute()) {
            command.execute();
        }
        HashMap<FunctionalExchange, FunctionalChainInvolvementLink> involvedExchanges = new HashMap<FunctionalExchange, FunctionalChainInvolvementLink>();
        HashMap<AbstractFunction, FunctionalChainInvolvementFunction> involvedFunctions = new HashMap<AbstractFunction, FunctionalChainInvolvementFunction>();
        for (EObject eObject : involvedElements) {
            if ((!(eObject instanceof AbstractFunction) || involvedFunctions.containsKey(eObject)) && (!(eObject instanceof FunctionalExchange) || involvedExchanges.containsKey(eObject))) continue;
            if (eObject instanceof FunctionalExchange) {
                AbstractFunction sourceFunction;
                FunctionalChainInvolvementLink newInvLink = FunctionalChainExt.createInvolvementLink((FunctionalChain)newFC, (InvolvedElement)eObject);
                involvedExchanges.put((FunctionalExchange)eObject, newInvLink);
                AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)eObject));
                if (!involvedFunctions.containsKey(targetFunction)) {
                    FunctionalChainInvolvementFunction newInvFunction = FunctionalChainExt.createInvolvementFunction((FunctionalChain)newFC, (InvolvedElement)targetFunction);
                    involvedFunctions.put(targetFunction, newInvFunction);
                }
                if (!involvedFunctions.containsKey(sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)eObject)))) {
                    FunctionalChainInvolvementFunction newInvFunction = FunctionalChainExt.createInvolvementFunction((FunctionalChain)newFC, (InvolvedElement)sourceFunction);
                    involvedFunctions.put(sourceFunction, newInvFunction);
                }
            }
            if (!(eObject instanceof AbstractFunction)) continue;
            FunctionalChainInvolvementFunction newInv = FunctionalChainExt.createInvolvementFunction((FunctionalChain)newFC, (InvolvedElement)eObject);
            involvedFunctions.put((AbstractFunction)eObject, newInv);
        }
        for (Map.Entry entry : involvedExchanges.entrySet()) {
            AbstractFunction sourceFunction;
            AbstractFunction targetFunction = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)((FunctionalExchange)entry.getKey()));
            if (involvedFunctions.containsKey(targetFunction)) {
                ((FunctionalChainInvolvementLink)entry.getValue()).setTarget((FunctionalChainInvolvementFunction)involvedFunctions.get(targetFunction));
            }
            if (!involvedFunctions.containsKey(sourceFunction = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)((FunctionalExchange)entry.getKey())))) continue;
            ((FunctionalChainInvolvementLink)entry.getValue()).setSource((FunctionalChainInvolvementFunction)involvedFunctions.get(sourceFunction));
        }
        return newFC;
    }

    public static FunctionalChainAbstractCapabilityInvolvement createFunctionalChainAbstractCapabilityInvolvement(AbstractCapability capability, FunctionalChain target) {
        for (FunctionalChainAbstractCapabilityInvolvement inv : capability.getOwnedFunctionalChainAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            return inv;
        }
        FunctionalChainAbstractCapabilityInvolvement newInv = InteractionFactory.eINSTANCE.createFunctionalChainAbstractCapabilityInvolvement();
        newInv.setInvolved((InvolvedElement)target);
        capability.getOwnedFunctionalChainAbstractCapabilityInvolvements().add((Object)newInv);
        return newInv;
    }

    public static FunctionalChainInvolvementFunction createInvolvementFunction(FunctionalChain fc, InvolvedElement involved) {
        FunctionalChainInvolvementFunction newInv = FaFactory.eINSTANCE.createFunctionalChainInvolvementFunction();
        fc.getOwnedFunctionalChainInvolvements().add((Object)newInv);
        newInv.setInvolved(involved);
        return newInv;
    }

    public static FunctionalChainInvolvementLink createInvolvementLink(FunctionalChain fc, InvolvedElement involved) {
        FunctionalChainInvolvementLink newInv = FaFactory.eINSTANCE.createFunctionalChainInvolvementLink();
        fc.getOwnedFunctionalChainInvolvements().add((Object)newInv);
        newInv.setInvolved(involved);
        return newInv;
    }

    public static List<FunctionalChain> getAllFunctionalChains(BlockArchitecture architecture) {
        BasicEList functionalChains = new BasicEList();
        AbstractCapabilityPkg pkg = architecture.getOwnedAbstractCapabilityPkg();
        if (pkg != null) {
            for (AbstractCapability aCapability : AbstractCapabilityPkgExt.getAllAbstractCapabilities(pkg)) {
                functionalChains.addAll((Collection)aCapability.getOwnedFunctionalChains());
            }
        }
        for (AbstractFunction abstractFunction : FunctionExt.getAllAbstractFunctions((BlockArchitecture)architecture)) {
            functionalChains.addAll((Collection)abstractFunction.getOwnedFunctionalChains());
        }
        return functionalChains;
    }

    public static Set<FunctionalChainInvolvement> getInvolvementsOf(FunctionalChain fc, InvolvedElement involved) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement anInvolvement : fc.getOwnedFunctionalChainInvolvements()) {
            if (!involved.equals(anInvolvement.getInvolved())) continue;
            result.add(anInvolvement);
        }
        return result;
    }

    public static Collection<FunctionalChainInvolvement> getFlatInvolvements(FunctionalChain functionalChain1) {
        ArrayList<FunctionalChainInvolvement> involvments = new ArrayList<FunctionalChainInvolvement>();
        LinkedList<FunctionalChain> toVisit = new LinkedList<FunctionalChain>();
        HashSet<FunctionalChain> visited = new HashSet<FunctionalChain>();
        toVisit.add(functionalChain1);
        while (!toVisit.isEmpty()) {
            FunctionalChain chain = (FunctionalChain)toVisit.removeFirst();
            if (visited.contains(chain)) continue;
            visited.add(chain);
            for (FunctionalChainInvolvement involvement : chain.getInvolvedFunctionalChainInvolvements()) {
                if (involvement.getInvolved() instanceof FunctionalChain) {
                    toVisit.add((FunctionalChain)involvement.getInvolved());
                }
                involvments.add(involvement);
            }
        }
        return involvments;
    }

    public static Set<FunctionalChainInvolvement> getInvolvementsOf(FunctionalChain fc, EClass involvedClass) {
        HashSet<FunctionalChainInvolvement> result = new HashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement anInvolvement : fc.getOwnedFunctionalChainInvolvements()) {
            if (anInvolvement.getInvolved() == null || !involvedClass.isInstance((Object)anInvolvement.getInvolved())) continue;
            result.add(anInvolvement);
        }
        return result;
    }

    public static Set<FunctionalExchange> getFunctionalExchanges(FunctionalChain fc) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getInvolvementsOf(fc, FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            if (involvement.getInvolved() == null) continue;
            result.add((FunctionalExchange)involvement.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalExchange> getFlatFunctionalExchanges(FunctionalChain fc) {
        HashSet<FunctionalExchange> result = new HashSet<FunctionalExchange>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf(fc, FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
            if (involvement.getInvolved() == null) continue;
            result.add((FunctionalExchange)involvement.getInvolved());
        }
        return result;
    }

    public static Set<AbstractFunction> getFlatFunctions(FunctionalChain fc) {
        LinkedHashSet<AbstractFunction> result = new LinkedHashSet<AbstractFunction>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvementsOf(fc, FaPackage.Literals.ABSTRACT_FUNCTION)) {
            if (involvement.getInvolved() == null) continue;
            result.add((AbstractFunction)involvement.getInvolved());
        }
        return result;
    }

    public static Set<FunctionalChainInvolvement> getFlatInvolvementsOf(FunctionalChain fc, EClass involvedClass) {
        LinkedHashSet<FunctionalChainInvolvement> result = new LinkedHashSet<FunctionalChainInvolvement>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvements(fc)) {
            if (involvement.getInvolved() == null || !involvedClass.isInstance((Object)involvement.getInvolved())) continue;
            result.add(involvement);
        }
        return result;
    }

    public static Set<EObject> getFlatInvolvedElements(FunctionalChain fc, EClass involvedClass) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (FunctionalChainInvolvement involvement : FunctionalChainExt.getFlatInvolvements(fc)) {
            if (involvement.getInvolved() == null || !involvedClass.isInstance((Object)involvement.getInvolved())) continue;
            result.add((EObject)involvement.getInvolved());
        }
        return result;
    }

    public static FunctionalChainDirectedGraph getFunctionalChainDirectedGraph(FunctionalChain functionalChain) {
        FunctionalChainExt functionalChainExt = new FunctionalChainExt();
        functionalChainExt.getClass();
        return functionalChainExt.new FunctionalChainDirectedGraph(functionalChain);
    }

    public static List<Component> getComponents(FunctionalChain functionalChain) {
        ArrayList<Component> result = new ArrayList<Component>();
        EList involvedElements = functionalChain.getInvolvedElements();
        for (InvolvedElement involvedElement : involvedElements) {
            List<Component> componentsFunc;
            if (!(involvedElement instanceof AbstractFunction) || (componentsFunc = AbstractFunctionExt.getMotherAllFunctionAllocation((AbstractFunction)involvedElement)).isEmpty()) continue;
            result.addAll(componentsFunc);
        }
        return result;
    }

    public static SequenceLink createSequenceLink(FunctionalChainInvolvementLink fciLink) {
        FunctionalChainInvolvementFunction fcifSource = fciLink.getSource();
        FunctionalChainInvolvementFunction fcifTarget = fciLink.getTarget();
        FunctionalChain functionalChain = (FunctionalChain)fciLink.eContainer();
        SequenceLink newSeqLink = FaFactory.eINSTANCE.createSequenceLink();
        newSeqLink.setSource((SequenceLinkEnd)fcifSource);
        newSeqLink.setTarget((SequenceLinkEnd)fcifTarget);
        functionalChain.getOwnedSequenceLinks().add((Object)newSeqLink);
        newSeqLink.getTargetReferenceHierarchy().addAll((Collection)fciLink.getTargetReferenceHierarchy());
        newSeqLink.getSourceReferenceHierarchy().addAll((Collection)fciLink.getSourceReferenceHierarchy());
        newSeqLink.getLinks().add((Object)fciLink);
        return newSeqLink;
    }

    public static Collection<ControlNode> getFlatControlNodes(FunctionalChain functionalChain) {
        ArrayList<ControlNode> ownedSequenceNodes = new ArrayList<ControlNode>();
        ownedSequenceNodes.addAll((Collection<ControlNode>)functionalChain.getOwnedSequenceNodes());
        functionalChain.getOwnedFunctionalChainInvolvements().stream().filter(FunctionalChainReference.class::isInstance).map(FunctionalChainReference.class::cast).map(Involvement::getInvolved).map(FunctionalChain.class::cast).distinct().forEach(fc -> {
            boolean bl = ownedSequenceNodes.addAll(FunctionalChainExt.getFlatControlNodes(fc));
        });
        return ownedSequenceNodes;
    }

    public static Collection<SequenceLink> getFlatSequenceLinks(FunctionalChain functionalChain) {
        ArrayList<SequenceLink> ownedSequenceLinks = new ArrayList<SequenceLink>();
        ownedSequenceLinks.addAll((Collection<SequenceLink>)functionalChain.getOwnedSequenceLinks());
        functionalChain.getOwnedFunctionalChainInvolvements().stream().filter(FunctionalChainReference.class::isInstance).map(FunctionalChainReference.class::cast).map(Involvement::getInvolved).map(FunctionalChain.class::cast).distinct().forEach(fc -> {
            boolean bl = ownedSequenceLinks.addAll(FunctionalChainExt.getFlatSequenceLinks(fc));
        });
        return ownedSequenceLinks;
    }

    public class FunctionalChainDirectedGraph
    implements IDirectedGraph<Object> {
        FunctionalChain chain;

        public FunctionalChainDirectedGraph(FunctionalChain functionalChain) {
            this.chain = functionalChain;
        }

        public Iterator<Object> getSucessors(Object source) {
            FunctionalChainInvolvement involvement;
            EList sucessors;
            if (source instanceof FunctionalChainInvolvement && (sucessors = (involvement = (FunctionalChainInvolvement)source).getNextFunctionalChainInvolvements()) != null) {
                return sucessors.iterator();
            }
            return new ArrayList().iterator();
        }

        public Iterator<Object> getNodes() {
            EList functionalChainInvolvements = this.chain.getInvolvedFunctionalChainInvolvements();
            if (functionalChainInvolvements != null) {
                return functionalChainInvolvements.iterator();
            }
            return new ArrayList().iterator();
        }
    }
}

