/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.model.helpers.ComponentExt;

public class OperationalAnalysisExt {
    public static List<Component> getComponentsFromBlockArchitecture(BlockArchitecture blockArchitecture) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (Object obj : blockArchitecture.eContents()) {
            if (obj instanceof Component) {
                list.add((Component)obj);
                continue;
            }
            if (!(obj instanceof Structure)) continue;
            for (Object content : ((Structure)obj).eContents()) {
                if (!(content instanceof Component)) continue;
                list.add((Component)content);
                list.addAll(ComponentExt.getComponentsFromComponent((Component)content));
            }
        }
        return list;
    }

    public static List<Entity> getAllEntity(EntityPkg ownedEntityPkg) {
        ArrayList<Entity> list = new ArrayList<Entity>(1);
        if (ownedEntityPkg != null) {
            Set scSet = EObjectExt.getAll((EObject)ownedEntityPkg, (EClass)OaPackage.Literals.ENTITY);
            for (EObject object : scSet) {
                list.add((Entity)object);
            }
        }
        return list;
    }

    public static List<Entity> getAllEntity(OperationalAnalysis arch) {
        EntityPkg ownedEntityPkg;
        ArrayList<Entity> list = new ArrayList<Entity>(1);
        if (arch != null && (ownedEntityPkg = arch.getOwnedEntityPkg()) != null) {
            Set scSet = EObjectExt.getAll((EObject)ownedEntityPkg, (EClass)OaPackage.Literals.ENTITY);
            for (EObject object : scSet) {
                list.add((Entity)object);
            }
        }
        return list;
    }

    public static List<Role> getAllRoles(OperationalAnalysis arch) {
        ArrayList<Role> list = new ArrayList<Role>();
        if (arch != null) {
            for (RolePkg aRolePkg : OperationalAnalysisExt.getAllRolePkgs(arch.getOwnedRolePkg())) {
                list.addAll((Collection<Role>)aRolePkg.getOwnedRoles());
            }
        }
        return list;
    }

    public static List<RolePkg> getAllRolePkgs(RolePkg rolePkg) {
        ArrayList<RolePkg> list = new ArrayList<RolePkg>();
        if (rolePkg != null) {
            list.add(rolePkg);
            for (RolePkg aRolePkg : rolePkg.getOwnedRolePkgs()) {
                list.addAll(OperationalAnalysisExt.getAllRolePkgs(aRolePkg));
            }
        }
        return list;
    }

    public static List<CommunicationMean> getAllCommunicationMeans(OperationalAnalysis arch) {
        EntityPkg ownedEntityPkg;
        ArrayList<CommunicationMean> list = new ArrayList<CommunicationMean>();
        if (arch != null && (ownedEntityPkg = arch.getOwnedEntityPkg()) != null) {
            for (EObject object : EObjectExt.getAll((EObject)ownedEntityPkg, (EClass)OaPackage.Literals.COMMUNICATION_MEAN)) {
                list.add((CommunicationMean)object);
            }
        }
        return list;
    }

    public static List<OperationalCapability> getAllOperationalCapabilities(OperationalAnalysis arch) {
        AbstractCapabilityPkg ownedAbstractCapabilityPkg;
        ArrayList<OperationalCapability> list = new ArrayList<OperationalCapability>(1);
        if (arch != null && (ownedAbstractCapabilityPkg = arch.getOwnedAbstractCapabilityPkg()) != null) {
            Set scSet = EObjectExt.getAll((EObject)ownedAbstractCapabilityPkg, (EClass)OaPackage.Literals.OPERATIONAL_CAPABILITY);
            for (EObject object : scSet) {
                list.add((OperationalCapability)object);
            }
        }
        return list;
    }
}

