/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.data.capellacommon.AbstractState;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.information.services.CommunicationLinkExt;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemInstance;
import org.polarsys.capella.core.data.information.ExchangeMechanism;
import org.polarsys.capella.core.data.information.communication.CommunicationLink;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkExchanger;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkKind;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.InteractionState;
import org.polarsys.capella.core.data.interaction.MessageEnd;
import org.polarsys.capella.core.data.interaction.MessageKind;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.interaction.StateFragment;
import org.polarsys.capella.core.data.interaction.TimeLapse;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;

public class ScenarioExt {
    public static Collection<AbstractFunction> getAvailableFunctionsStateFragment(AbstractInstance instance) {
        if (instance instanceof Role) {
            Role role = (Role)instance;
            ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
            for (ActivityAllocation alloc : role.getActivityAllocations()) {
                result.add((AbstractFunction)alloc.getActivity());
            }
            return result;
        }
        if (instance.getAbstractType() instanceof Component) {
            Component component = (Component)instance.getAbstractType();
            return ScenarioExt.getAvailableFunctionsStateFragment(component);
        }
        return Collections.emptyList();
    }

    public static Collection<AbstractFunction> getAvailableFunctionsStateFragment(Component component) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        HashSet functions = new HashSet();
        ArrayList<Component> baseComponents = new ArrayList<Component>();
        baseComponents.add(component);
        baseComponents.addAll(ComponentExt.getAllSubUsedAndDeployedComponents(component));
        for (Component baseComponent : baseComponents) {
            List elements = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)baseComponent);
            elements.add(baseComponent);
            for (GeneralizableElement element : elements) {
                if (!(element instanceof AbstractFunctionalBlock)) continue;
                functions.addAll(((AbstractFunctionalBlock)element).getAllocatedFunctions());
            }
        }
        result.addAll(functions);
        ArrayList<AbstractFunction> newElements = new ArrayList<AbstractFunction>();
        do {
            newElements.clear();
            for (AbstractFunction abstractFunction : result) {
                AbstractFunction af;
                EObject container = abstractFunction.eContainer();
                if (!(container instanceof AbstractFunction) || result.contains(af = (AbstractFunction)container)) continue;
                boolean allInnerAreInResult = true;
                for (EObject inner : af.eContents()) {
                    AbstractFunction innerAf;
                    if (!(inner instanceof AbstractFunction) || result.contains(innerAf = (AbstractFunction)inner)) continue;
                    allInnerAreInResult = false;
                }
                if (!allInnerAreInResult) continue;
                newElements.add(af);
            }
            result.addAll(newElements);
        } while (newElements.size() > 0);
        return result;
    }

    public static Collection<AbstractState> getAvailableStateModeStateFragment(AbstractInstance instance) {
        HashSet<AbstractState> result;
        block6: {
            block5: {
                result = new HashSet<AbstractState>();
                HashSet stateMachinas = new HashSet();
                if (!(instance instanceof Part)) break block5;
                Collection<Part> parts = ComponentExt.getPartAncestors((Part)instance, true);
                parts.add((Part)instance);
                for (Part part : parts) {
                    if (part.getAbstractType() == null) continue;
                    Component component = (Component)part.getAbstractType();
                    List elements = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)component);
                    elements.add(component);
                    for (GeneralizableElement element : elements) {
                        if (!(element instanceof Block)) continue;
                        stateMachinas.addAll(((Block)element).getOwnedStateMachines());
                    }
                }
                for (StateMachine machina : stateMachinas) {
                    TreeIterator childs = machina.eAllContents();
                    while (childs.hasNext()) {
                        EObject child = (EObject)childs.next();
                        if (!(child instanceof AbstractState)) continue;
                        result.add((AbstractState)child);
                    }
                }
                break block6;
            }
            if (!(instance instanceof AbstractFunction)) break block6;
            AbstractFunction af = (AbstractFunction)instance;
            for (State asm : af.getAvailableInStates()) {
                result.add((AbstractState)asm);
            }
        }
        return result;
    }

    public static List<Scenario> getScenariosFromEvent(Event event) {
        ArrayList<Scenario> listScenario = new ArrayList<Scenario>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)event, (EReference)InteractionPackage.Literals.ABSTRACT_END__EVENT)) {
            Scenario scenario;
            if (!(objectRef instanceof MessageEnd) || listScenario.contains(scenario = (Scenario)((MessageEnd)objectRef).eContainer())) continue;
            listScenario.add(scenario);
        }
        return listScenario;
    }

    public static boolean createdByRefinement(Scenario scenario) {
        return ScenarioExt.getUpperScenario(scenario) != null;
    }

    public static Scenario getUpperScenario(Scenario scenario) {
        Scenario upperScenario = null;
        for (CapellaElement target : RefinementLinkExt.getRefinementRelatedTargetElements((CapellaElement)scenario, InteractionPackage.Literals.SCENARIO)) {
            upperScenario = (Scenario)target;
        }
        return upperScenario;
    }

    public static List<Scenario> getSubScenarios(Scenario scenario) {
        ArrayList<Scenario> subScenarios = new ArrayList<Scenario>();
        for (CapellaElement source : RefinementLinkExt.getRefinementRelatedSourceElements((CapellaElement)scenario, InteractionPackage.Literals.SCENARIO)) {
            subScenarios.add((Scenario)source);
        }
        return subScenarios;
    }

    public static boolean contains(Scenario scenario, Component cpnt) {
        return ScenarioExt.getOwnedComponents(scenario).contains(cpnt);
    }

    public static boolean contains(Scenario scenario, Part part) {
        return ScenarioExt.getOwnedParts(scenario).contains(part);
    }

    public static List<LogicalComponent> getOwnedLogicalComponents(Scenario scenario) {
        ArrayList<LogicalComponent> logicalComponentSet = new ArrayList<LogicalComponent>();
        for (Component cpnt : ScenarioExt.getOwnedComponents(scenario)) {
            if (!(cpnt instanceof LogicalComponent)) continue;
            logicalComponentSet.add((LogicalComponent)cpnt);
        }
        return logicalComponentSet;
    }

    public static List<PhysicalComponent> getOwnedPhysicalComponents(Scenario scenario) {
        ArrayList<PhysicalComponent> physicalComponentSet = new ArrayList<PhysicalComponent>();
        for (Component cpnt : ScenarioExt.getOwnedComponents(scenario)) {
            if (!(cpnt instanceof PhysicalComponent)) continue;
            physicalComponentSet.add((PhysicalComponent)cpnt);
        }
        return physicalComponentSet;
    }

    public static List<ConfigurationItem> getOwnedConfigurationItems(Scenario scenario) {
        ArrayList<ConfigurationItem> configurationItemSet = new ArrayList<ConfigurationItem>();
        for (Component cpnt : ScenarioExt.getOwnedComponents(scenario)) {
            if (!(cpnt instanceof ConfigurationItem)) continue;
            configurationItemSet.add((ConfigurationItem)cpnt);
        }
        return configurationItemSet;
    }

    public static List<Component> getOwnedComponents(Scenario scenario) {
        ArrayList<Component> cpntSet = new ArrayList<Component>();
        for (Part part : ScenarioExt.getOwnedParts(scenario)) {
            Component cpnt = (Component)part.getType();
            if (cpnt == null) continue;
            cpntSet.add(cpnt);
        }
        List<Component> allocatedComponents = ScenarioExt.getFunctionAllocatedComponents(scenario);
        if (!allocatedComponents.isEmpty()) {
            cpntSet.addAll(allocatedComponents);
        }
        return cpntSet;
    }

    public static List<Part> getOwnedParts(Scenario scenario) {
        ArrayList<Part> partSet = new ArrayList<Part>();
        for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
            AbstractInstance inst = role.getRepresentedInstance();
            if (!(inst instanceof Part)) continue;
            partSet.add((Part)inst);
        }
        return partSet;
    }

    public static List<Component> getFunctionAllocatedComponents(Scenario scenario) {
        ArrayList<Component> result = new ArrayList<Component>();
        EList ownedInstances = scenario.getOwnedInstanceRoles();
        for (InstanceRole instance : ownedInstances) {
            List<Component> componentsFunc;
            AbstractInstance representedInstance = instance.getRepresentedInstance();
            if (!(representedInstance instanceof AbstractFunction) || (componentsFunc = AbstractFunctionExt.getMotherAllFunctionAllocation((AbstractFunction)representedInstance)).isEmpty()) continue;
            result.addAll(componentsFunc);
        }
        return result;
    }

    public static List<AbstractEnd> getOwnedAbstractEnds(Scenario scenario) {
        ArrayList<AbstractEnd> ownedMsgEnd = new ArrayList<AbstractEnd>();
        for (InteractionFragment abs : scenario.getOwnedInteractionFragments()) {
            if (!(abs instanceof AbstractEnd)) continue;
            ownedMsgEnd.add((AbstractEnd)abs);
        }
        return ownedMsgEnd;
    }

    public static List<MessageEnd> getOwnedMessagesEnds(Scenario scenario) {
        ArrayList<MessageEnd> ownedMsgEnd = new ArrayList<MessageEnd>();
        for (InteractionFragment abs : scenario.getOwnedInteractionFragments()) {
            if (!(abs instanceof MessageEnd)) continue;
            ownedMsgEnd.add((MessageEnd)abs);
        }
        return ownedMsgEnd;
    }

    public static AbstractCapability getRelatedCapability(Scenario scenario) {
        if (scenario != null) {
            return (AbstractCapability)scenario.eContainer();
        }
        return null;
    }

    public static NamedElement getContainer(Scenario scenario) {
        return ScenarioExt.getRecursiveContainer((NamedElement)scenario);
    }

    private static NamedElement getRecursiveContainer(NamedElement elt) {
        NamedElement result = null;
        if (elt != null) {
            NamedElement container = (NamedElement)elt.eContainer();
            result = container instanceof SystemEngineering ? container : (container instanceof LogicalArchitecture ? container : (container instanceof LogicalComponent ? container : (container instanceof PhysicalArchitecture ? container : (container instanceof PhysicalComponent ? container : (container instanceof EPBSArchitecture ? container : ScenarioExt.getRecursiveContainer(container))))));
        }
        return result;
    }

    public static EObject moveEndOnBeginingOfScenario(InteractionFragment toMove) {
        EList ownedAbstractEnds = ((Scenario)toMove.eContainer()).getOwnedInteractionFragments();
        ownedAbstractEnds.move(0, (Object)toMove);
        return toMove;
    }

    public static EObject moveEndOnScenario(InteractionFragment toMove, InteractionFragment previousEnd) {
        EObject previousEndContainer = previousEnd.eContainer();
        EList ownedAbstractEnds = null;
        if (previousEndContainer instanceof Scenario) {
            ownedAbstractEnds = ((Scenario)previousEndContainer).getOwnedInteractionFragments();
        }
        if (ownedAbstractEnds != null && ownedAbstractEnds.contains((Object)toMove)) {
            ownedAbstractEnds.move(ownedAbstractEnds.size() - 1, (Object)toMove);
        } else if (ownedAbstractEnds != null) {
            ownedAbstractEnds.add((Object)toMove);
        }
        if (ownedAbstractEnds != null) {
            int newIndex = ownedAbstractEnds.indexOf((Object)previousEnd) + 1;
            if (newIndex >= ownedAbstractEnds.size()) {
                newIndex = ownedAbstractEnds.size() - 1;
            }
            ownedAbstractEnds.move(newIndex, (Object)toMove);
        }
        return toMove;
    }

    public static EObject moveInteractionFragmentAfter(InteractionFragment element, InteractionFragment elementReference) {
        if (elementReference == null) {
            return ScenarioExt.moveEndOnBeginingOfScenario(element);
        }
        return ScenarioExt.moveEndOnScenario(element, elementReference);
    }

    public static List<CapellaElement> getAvailableExchangeItemsBetweenInstances(AbstractInstance sendingInstance, AbstractInstance receivingInstance, MessageKind messageKind) {
        ExchangeItem involvedExchangeItem = null;
        if (sendingInstance instanceof ExchangeItemInstance) {
            involvedExchangeItem = (ExchangeItem)sendingInstance.getAbstractType();
        }
        if (receivingInstance instanceof ExchangeItemInstance) {
            involvedExchangeItem = (ExchangeItem)receivingInstance.getAbstractType();
        }
        BlockArchitecture architecture = ComponentExt.getRootBlockArchitecture((ModelElement)sendingInstance);
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        boolean isSharedDataAccess = sendingInstance instanceof ExchangeItemInstance || receivingInstance instanceof ExchangeItemInstance;
        List items = QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_EXCHANGE_ITEMS_FOR_LIB, (Object)architecture, (IQueryContext)new QueryContext());
        for (ExchangeItem item : items) {
            if (isSharedDataAccess) {
                if (item != involvedExchangeItem) continue;
                result.add((CapellaElement)item);
                result.addAll(ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)item));
                continue;
            }
            if (messageKind == MessageKind.SYNCHRONOUS_CALL && (item.getExchangeMechanism() == ExchangeMechanism.FLOW || item.getExchangeMechanism() == ExchangeMechanism.OPERATION)) {
                result.add((CapellaElement)item);
                result.addAll(ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)item));
                continue;
            }
            if (messageKind == MessageKind.ASYNCHRONOUS_CALL && item.getExchangeMechanism() != ExchangeMechanism.UNSET) {
                result.add((CapellaElement)item);
                result.addAll(ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)item));
                continue;
            }
            if (messageKind != MessageKind.DELETE && messageKind != MessageKind.CREATE) continue;
            result.add((CapellaElement)item);
            result.addAll(ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)item));
        }
        return result;
    }

    public static SequenceMessage getReply(SequenceMessage message) {
        MessageEnd end = message.getReceivingEnd();
        List allocations = EObjectExt.getReferencers((EObject)end, (EReference)InteractionPackage.Literals.TIME_LAPSE__START);
        for (Execution obj : allocations) {
            if (!(obj.getFinish() instanceof MessageEnd)) continue;
            return ((MessageEnd)obj.getFinish()).getMessage();
        }
        return null;
    }

    public static boolean hasReply(SequenceMessage message) {
        return ScenarioExt.getReply(message) != null;
    }

    public static List<CapellaElement> getRestrictedExchangeItems(InstanceRole source, InstanceRole target, boolean isSynchronous) {
        CommunicationLinkProtocol protocol;
        ArrayList<CapellaElement> result = new ArrayList<CapellaElement>();
        Component client = null;
        Component provider = null;
        AbstractExchangeItem eiClient = null;
        if (source != null) {
            if (source.getRepresentedInstance().getAbstractType() instanceof Component) {
                client = (Component)source.getRepresentedInstance().getAbstractType();
            } else {
                eiClient = (AbstractExchangeItem)source.getRepresentedInstance().getAbstractType();
            }
        } else {
            client = null;
        }
        if (target != null) {
            if (target.getRepresentedInstance().getAbstractType() instanceof Component) {
                provider = (Component)target.getRepresentedInstance().getAbstractType();
            } else {
                eiClient = (AbstractExchangeItem)target.getRepresentedInstance().getAbstractType();
            }
        } else {
            provider = null;
        }
        if ((client == null || provider == null) && isSynchronous) {
            Component temp = client;
            client = provider;
            provider = temp;
        }
        ArrayList<Object> potentialEI = new ArrayList<Object>();
        if (provider != null) {
            for (CommunicationLink communicationLink : CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)provider)) {
                if (communicationLink.getKind() != CommunicationLinkKind.RECEIVE && communicationLink.getKind() != CommunicationLinkKind.CONSUME && communicationLink.getKind() != CommunicationLinkKind.EXECUTE && communicationLink.getKind() != CommunicationLinkKind.ACCESS) continue;
                if (CommunicationLinkKind.ACCESS == communicationLink.getKind()) {
                    protocol = communicationLink.getProtocol();
                    if (isSynchronous && CommunicationLinkProtocol.READ == protocol) {
                        potentialEI.add(communicationLink.getExchangeItem());
                    }
                    if (!isSynchronous && CommunicationLinkProtocol.ACCEPT == protocol) {
                        potentialEI.add(communicationLink.getExchangeItem());
                    }
                    if (CommunicationLinkProtocol.UNSET != protocol) continue;
                    potentialEI.add(communicationLink.getExchangeItem());
                    continue;
                }
                potentialEI.add(communicationLink.getExchangeItem());
            }
        } else if (eiClient != null) {
            potentialEI.add((AbstractExchangeItem)target.getRepresentedInstance().getAbstractType());
        }
        if (client != null) {
            for (CommunicationLink communicationLink : CommunicationLinkExt.getAllCommunicationLinks((CommunicationLinkExchanger)client)) {
                if (communicationLink.getKind() != CommunicationLinkKind.CALL && communicationLink.getKind() != CommunicationLinkKind.PRODUCE && communicationLink.getKind() != CommunicationLinkKind.SEND && communicationLink.getKind() != CommunicationLinkKind.WRITE || !potentialEI.contains(communicationLink.getExchangeItem())) continue;
                protocol = communicationLink.getProtocol();
                if (communicationLink.getKind() == CommunicationLinkKind.CALL) {
                    if (isSynchronous && protocol == CommunicationLinkProtocol.SYNCHRONOUS) {
                        result.add((CapellaElement)communicationLink.getExchangeItem());
                    }
                    if (!isSynchronous && protocol == CommunicationLinkProtocol.ASYNCHRONOUS) {
                        result.add((CapellaElement)communicationLink.getExchangeItem());
                    }
                    if (protocol != CommunicationLinkProtocol.UNSET) continue;
                    result.add((CapellaElement)communicationLink.getExchangeItem());
                    continue;
                }
                result.add((CapellaElement)communicationLink.getExchangeItem());
            }
        } else {
            for (AbstractExchangeItem abstractExchangeItem : potentialEI) {
                if (abstractExchangeItem != eiClient) continue;
                result.add((CapellaElement)eiClient);
                List eiaPotentials = EObjectExt.getReferencers((EObject)abstractExchangeItem, (EReference)CsPackage.Literals.EXCHANGE_ITEM_ALLOCATION__ALLOCATED_ITEM);
                for (EObject eObject : eiaPotentials) {
                    if (!(eObject instanceof ExchangeItemAllocation)) continue;
                    ExchangeItemAllocation eia = (ExchangeItemAllocation)eObject;
                    result.add((CapellaElement)eia);
                }
            }
        }
        return result;
    }

    public static boolean isFunctionalScenario(Scenario scenario) {
        for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
            if (!(ir.getRepresentedInstance() instanceof AbstractFunction)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDataFlowBehaviouralScenario(Scenario scenario) {
        if (scenario.getKind() == ScenarioKind.INTERACTION || scenario.getKind() == ScenarioKind.DATA_FLOW) {
            for (SequenceMessage message : scenario.getOwnedMessages()) {
                if (!(message.getInvokedOperation() instanceof ComponentExchange)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isDataFlowFunctionalScenario(Scenario scenario) {
        if (scenario.getKind() == ScenarioKind.INTERACTION || scenario.getKind() == ScenarioKind.DATA_FLOW) {
            for (SequenceMessage message : scenario.getOwnedMessages()) {
                if (!(message.getInvokedOperation() instanceof FunctionalExchange)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getTargetOnExchangeItem(Object object) {
        List objs = (List)object;
        Execution result = null;
        if (objs == null) {
            return null;
        }
        for (EObject eObject : objs) {
            InstanceRole ir;
            Execution exec;
            if (eObject instanceof Execution && (exec = (Execution)eObject).getCovered().getRepresentedInstance() instanceof ExchangeItemInstance) {
                result = exec;
            }
            if (!(eObject instanceof InstanceRole) || !((ir = (InstanceRole)eObject).getRepresentedInstance() instanceof ExchangeItemInstance)) continue;
            result = ir;
        }
        return result;
    }

    public static boolean canRealize(Scenario scenario, Scenario scenario2) {
        ScenarioKind sourceKind = scenario.getKind();
        ScenarioKind targetKind = scenario2.getKind();
        if (scenario2.isMerged()) {
            return false;
        }
        if (targetKind.equals((Object)sourceKind)) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario);
            BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)scenario2);
            if (sourceArchitecture == null || sourceArchitecture.equals(targetArchitecture)) {
                return ScenarioKind.DATA_FLOW.equals((Object)sourceKind) || ScenarioKind.INTERACTION.equals((Object)sourceKind) && (ScenarioExt.isFunctionalScenario(scenario2) || scenario2.getOwnedInstanceRoles().isEmpty());
            }
            return true;
        }
        if (ScenarioKind.DATA_FLOW.equals((Object)sourceKind)) {
            return ScenarioKind.FUNCTIONAL.equals((Object)targetKind) || ScenarioKind.INTERACTION.equals((Object)targetKind);
        }
        if (ScenarioKind.INTERFACE.equals((Object)sourceKind)) {
            return ScenarioKind.DATA_FLOW.equals((Object)targetKind);
        }
        if (ScenarioKind.FUNCTIONAL.equals((Object)sourceKind)) {
            return ScenarioKind.INTERACTION.equals((Object)targetKind) && (ScenarioExt.isFunctionalScenario(scenario2) || scenario2.getOwnedInstanceRoles().isEmpty());
        }
        return false;
    }

    public static Collection<Part> getAllAvailableParts(EObject any, Collection<Part> filter) {
        ArrayList<Part> result = new ArrayList<Part>();
        EObject component = EcoreUtil2.getFirstContainer((EObject)any, (EClass)CsPackage.Literals.COMPONENT);
        if (component != null) {
            Component comp = (Component)component;
            ScenarioExt.getAllOwnedPart(result, comp, filter);
        } else {
            BlockArchitecture architecture;
            Component rootComponent;
            EObject arch = EcoreUtil2.getFirstContainer((EObject)any, (EClass)CsPackage.Literals.BLOCK_ARCHITECTURE);
            if (arch != null && (rootComponent = (architecture = (BlockArchitecture)arch).getSystem()) != null) {
                ScenarioExt.getAllOwnedPart(result, rootComponent, filter);
            }
        }
        return result;
    }

    private static void getAllOwnedPart(Collection<Part> result, Component rootComponent, Collection<Part> filter) {
        EList ownedParts = rootComponent.getContainedParts();
        for (Part part : ownedParts) {
            if (filter.contains(part)) continue;
            result.add(part);
            if (!(part.getAbstractType() instanceof Component)) continue;
            ScenarioExt.getAllOwnedPart(result, (Component)part.getAbstractType(), filter);
        }
    }

    public static List<Component> getAllActors(EObject any) {
        ModellingArchitecture architecture = (ModellingArchitecture)EcoreUtil2.getFirstContainer((EObject)any, (EClass)CapellacorePackage.Literals.MODELLING_ARCHITECTURE);
        LinkedList<Component> result = new LinkedList<Component>();
        if (architecture instanceof EPBSArchitecture) {
            SystemEngineering se = (SystemEngineering)architecture.eContainer();
            for (ModellingArchitecture ma : se.getOwnedArchitectures()) {
                if (!(ma instanceof PhysicalArchitecture)) continue;
                architecture = ma;
            }
        }
        TreeIterator iterContents = architecture.eAllContents();
        while (iterContents.hasNext()) {
            EObject next = (EObject)iterContents.next();
            if (!(next instanceof Component) || !((Component)next).isActor()) continue;
            result.add((Component)next);
        }
        return result;
    }

    public static Collection<Part> getAllComponents(EObject any, Collection<Part> filter) {
        ModellingArchitecture architecture = (ModellingArchitecture)EcoreUtil2.getFirstContainer((EObject)any, (EClass)CapellacorePackage.Literals.MODELLING_ARCHITECTURE);
        Component rootComponent = null;
        if (architecture instanceof LogicalArchitecture || architecture instanceof PhysicalArchitecture) {
            rootComponent = ((BlockArchitecture)architecture).getSystem();
        }
        LinkedList<Part> result = new LinkedList<Part>();
        if (architecture != null) {
            TreeIterator iterContents = architecture.eAllContents();
            while (iterContents.hasNext()) {
                EObject next = (EObject)iterContents.next();
                if (!CsPackage.eINSTANCE.getPart().isInstance((Object)next)) continue;
                Part currentPart = (Part)next;
                if (!CsPackage.eINSTANCE.getComponent().isInstance((Object)currentPart.getAbstractType()) || filter.contains(currentPart) || currentPart.getAbstractType().equals(rootComponent)) continue;
                result.add(currentPart);
            }
        }
        return result;
    }

    public static boolean checkOrdering(Scenario scenario) {
        for (TimeLapse tl : scenario.getOwnedTimeLapses()) {
            InteractionFragment beginIf = tl.getStart();
            InteractionFragment finishIf = tl.getFinish();
            EList ownedInteractionFragments = scenario.getOwnedInteractionFragments();
            int beginIndex = ownedInteractionFragments.indexOf((Object)beginIf);
            int endIndex = ownedInteractionFragments.indexOf((Object)finishIf);
            if (endIndex >= beginIndex) continue;
            return false;
        }
        return true;
    }

    public static void reorderTimeLapseFragments(Scenario scenario) {
        for (TimeLapse tl : scenario.getOwnedTimeLapses()) {
            InteractionFragment beginIf = tl.getStart();
            InteractionFragment finishIf = tl.getFinish();
            EList ownedInteractionFragments = scenario.getOwnedInteractionFragments();
            int beginIndex = ownedInteractionFragments.indexOf((Object)beginIf);
            int endIndex = ownedInteractionFragments.indexOf((Object)finishIf);
            ownedInteractionFragments.remove((Object)beginIf);
            ownedInteractionFragments.add(endIndex, (Object)beginIf);
            ownedInteractionFragments.remove((Object)finishIf);
            ownedInteractionFragments.add(beginIndex, (Object)finishIf);
        }
    }

    public static boolean isInterfaceScenario(Scenario scenario) {
        return scenario.getKind() == ScenarioKind.INTERFACE;
    }

    public static StateFragment getFragment(InteractionState state) {
        List allocations = EObjectExt.getReferencers((EObject)state, (EReference)InteractionPackage.Literals.TIME_LAPSE__START);
        if (allocations.size() == 1 && allocations.get(0) instanceof StateFragment) {
            return (StateFragment)allocations.get(0);
        }
        allocations = EObjectExt.getReferencers((EObject)state, (EReference)InteractionPackage.Literals.TIME_LAPSE__FINISH);
        if (allocations.size() == 1 && allocations.get(0) instanceof StateFragment) {
            return (StateFragment)allocations.get(0);
        }
        return null;
    }

    public static Collection<InstanceRole> getCoveredInstanceRoles(StateFragment state) {
        ArrayList<InstanceRole> roles = new ArrayList<InstanceRole>();
        for (InstanceRole role : state.getStart().getCoveredInstanceRoles()) {
            if (roles.contains(role)) continue;
            roles.add(role);
        }
        for (InstanceRole role : state.getFinish().getCoveredInstanceRoles()) {
            if (roles.contains(role)) continue;
            roles.add(role);
        }
        return roles;
    }

    public static void reorderScenario(Scenario scenario) {
        EList messages = scenario.getOwnedMessages();
        ArrayList<SequenceMessage> messagesOrdered = new ArrayList<SequenceMessage>(messages.size());
        for (SequenceMessage sequenceMessage : messages) {
            messagesOrdered.add(sequenceMessage);
        }
        int index = 0;
        for (InteractionFragment if_ : scenario.getOwnedInteractionFragments()) {
            MessageEnd me;
            SequenceMessage message;
            if (!(if_ instanceof MessageEnd) || (message = (me = (MessageEnd)if_).getMessage()) == null) continue;
            if (message.getSendingEnd() != null && message.getSendingEnd().equals(me)) {
                messagesOrdered.remove(message);
                messagesOrdered.add(index, message);
                ++index;
            }
            if (message.getSendingEnd() != null || message.getReceivingEnd() == null || !message.getReceivingEnd().equals(me)) continue;
            messagesOrdered.remove(message);
            messagesOrdered.add(index, message);
            ++index;
        }
        if (!messages.equals(messagesOrdered)) {
            scenario.getOwnedMessages().clear();
            scenario.getOwnedMessages().addAll(messagesOrdered);
        }
    }

    public static boolean isMultiInstanceRole(Scenario scenario) {
        HashSet<AbstractInstance> is = new HashSet<AbstractInstance>();
        for (InstanceRole ir : scenario.getOwnedInstanceRoles()) {
            if (ir.getRepresentedInstance() == null || is.add(ir.getRepresentedInstance())) continue;
            return true;
        }
        return false;
    }

    public static AbstractType getAbstractType(EObject obj) {
        AbstractType type = null;
        if (obj instanceof InstanceRole) {
            type = ((InstanceRole)obj).getRepresentedInstance().getAbstractType();
        }
        return type;
    }
}

