/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.views.libraryManager.activeStateManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.LibraryContentProvider;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.activeStateManager.ActiveStateLabelProvider;

public class ActiveStateManagerWidget {
    protected Table table;
    protected TableViewer tableViewer;
    protected LibraryManagerModel model;
    private IProperty property;
    private IRendererContext rendererContext;

    public ActiveStateManagerWidget(Composite parent) {
        this.tableViewer = new TableViewer(parent, 2080);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = this.tableViewer.getTable();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ActiveStateLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                IModel library = (IModel)item.getData();
                if (event.detail == 32) {
                    if (item.getGrayed()) {
                        item.setChecked(true);
                    } else {
                        if (!item.getChecked()) {
                            ActiveStateManagerWidget.this.model.setActiveState(library, false);
                        } else {
                            ActiveStateManagerWidget.this.model.setActiveState(library, true);
                        }
                        ActiveStateManagerWidget.this.refreshView();
                        ActiveStateManagerWidget.this.notifyValueModification();
                    }
                }
            }
        });
    }

    public void initializeView(LibraryManagerModel model_, IProperty property_, IRendererContext rendererContext_) {
        this.model = model_;
        this.property = property_;
        this.rendererContext = rendererContext_;
        this.refreshView();
    }

    protected void refreshView() {
        List allReferencedLibraries = this.model.getAllReferencedLibrariesByRootModel();
        this.tableViewer.setInput((Object)allReferencedLibraries.toArray());
        ArrayList<TableItem> itemsToBeChecked = new ArrayList<TableItem>();
        List<TableItem> items = Arrays.asList(this.table.getItems());
        for (IModel library : allReferencedLibraries) {
            if (!this.model.getActiveState(library).booleanValue()) continue;
            itemsToBeChecked.add(this.table.getItem(allReferencedLibraries.indexOf(library)));
        }
        for (TableItem item : items) {
            item.setChecked(itemsToBeChecked.contains(item));
        }
    }

    protected void notifyValueModification() {
        this.rendererContext.getPropertyContext().setCurrentValue(this.property, (Object)this.model);
    }
}

