/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.views.libraryManager.referencesManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.IModelIdentifier;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.libraries.properties.LibraryManagerModel;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.LibraryContentProvider;
import org.polarsys.capella.core.libraries.ui.views.libraryManager.referencesManager.ReferencesLabelProvider;

public class ReferencesManagerWidget {
    protected Table table;
    protected TableViewer tableViewer;
    protected LibraryManagerModel model;
    private IProperty property;
    private IRendererContext rendererContext;

    public ReferencesManagerWidget(Composite parent) {
        this.tableViewer = new TableViewer(parent, 2080);
        this.tableViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.table = this.tableViewer.getTable();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ReferencesLabelProvider());
        this.tableViewer.setContentProvider((IContentProvider)new LibraryContentProvider());
        this.tableViewer.getTable().setLinesVisible(true);
        this.tableViewer.getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                IModel library = (IModel)item.getData();
                if (!LibraryManagerExt.getAllUnavailableReferences((IModel)library).isEmpty()) {
                    ReferencesManagerWidget.this.refreshView();
                    return;
                }
                if (event.detail == 32) {
                    if (!item.getChecked() && !item.getGrayed()) {
                        ReferencesManagerWidget.this.model.removeReferencedLibrary(library);
                    } else {
                        ReferencesManagerWidget.this.model.addReferencedLibrary(library);
                    }
                    ReferencesManagerWidget.this.refreshView();
                    ReferencesManagerWidget.this.notifyValueModification();
                }
            }
        });
    }

    public void initializeView(LibraryManagerModel model_, IProperty property_, IRendererContext rendererContext_) {
        this.model = model_;
        this.property = property_;
        this.rendererContext = rendererContext_;
        this.tableViewer.setInput((Object)this.model.getAllLibraries().toArray());
        this.refreshView();
    }

    protected void refreshView() {
        int index;
        ArrayList<TableItem> itemsToBeChecked = new ArrayList<TableItem>();
        ArrayList<TableItem> itemsToBeGrayed = new ArrayList<TableItem>();
        ArrayList<TableItem> itemsToBeDisabled = new ArrayList<TableItem>();
        ArrayList<TableItem> itemsToBeItalicAndRed = new ArrayList<TableItem>();
        List<TableItem> items = Arrays.asList(this.table.getItems());
        Collection currentReferencedLibraries = this.model.getReferencedLibrariesByRootModel();
        for (IModel library : currentReferencedLibraries) {
            index = this.model.getAllLibraries().indexOf(library);
            if (index < 0) continue;
            itemsToBeChecked.add(this.table.getItem(index));
        }
        int i = 0;
        while (i < this.model.getAllLibraries().size()) {
            if (!LibraryManagerExt.getAllUnavailableReferences((IModel)((IModel)this.model.getAllLibraries().get(i))).isEmpty()) {
                itemsToBeDisabled.add(this.table.getItem(i));
            }
            ++i;
        }
        for (IModel library : currentReferencedLibraries) {
            index = this.model.getAllLibraries().indexOf(library);
            if (index < 0 || !CapellaLibraryExt.isUnresolvableIdentifier((IModelIdentifier)library.getIdentifier())) continue;
            itemsToBeItalicAndRed.add(this.table.getItem(index));
        }
        for (IModel library : this.model.getAllReferencedLibrariesByRootModel()) {
            if (currentReferencedLibraries.contains(library)) continue;
            TableItem item = this.table.getItem(this.model.getAllLibraries().indexOf(library));
            itemsToBeChecked.add(item);
            itemsToBeGrayed.add(item);
        }
        for (TableItem item : items) {
            item.setChecked(itemsToBeChecked.contains(item));
        }
        for (TableItem item : items) {
            item.setGrayed(itemsToBeGrayed.contains(item));
        }
        for (TableItem item : items) {
            if (itemsToBeDisabled.contains(item)) {
                item.setForeground(Display.getDefault().getSystemColor(16));
                continue;
            }
            item.setForeground(Display.getDefault().getSystemColor(2));
        }
        for (TableItem item : itemsToBeItalicAndRed) {
            item.setForeground(Display.getDefault().getSystemColor(3));
            item.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        }
    }

    protected void notifyValueModification() {
        this.rendererContext.getPropertyContext().setCurrentValue(this.property, (Object)this.model);
    }
}

