/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.project;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.platform.sirius.ui.project.Messages;
import org.polarsys.capella.core.platform.sirius.ui.project.NewModelWizardPage;
import org.polarsys.capella.core.platform.sirius.ui.project.operations.ProjectSessionCreationHelper;

public class NewModelWizard
extends BasicNewResourceWizard {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private NewModelWizardPage _mainPage;

    public void init(IWorkbench workbench_p, IStructuredSelection currentSelection_p) {
        super.init(workbench_p, currentSelection_p);
        this.setWindowTitle(Messages.getString("NewModelWizard.window.title"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this._mainPage = new NewModelWizardPage("model.creation.page");
        this._mainPage.setTitle(Messages.getString("NewModelWizard.title"));
        this._mainPage.setDescription(Messages.getString("NewModelWizard.description"));
        this.addPage((IWizardPage)this._mainPage);
    }

    public boolean performFinish() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor_p) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor_p, (String)(String.valueOf(Messages.getString("NewModelWizard.title")) + NewModelWizard.this._mainPage.getModelName()), (int)1);
                        Object selectedObject = null;
                        if (NewModelWizard.this.getSelection() != null && (selectedObject = NewModelWizard.this.getSelection().getFirstElement()) instanceof Project) {
                            ProjectSessionCreationHelper helper = NewModelWizard.this.createSessionCreationHelper();
                            helper.createNewSystemEngineering(((EObject)selectedObject).eResource(), NewModelWizard.this._mainPage.getModelName(), (IProgressMonitor)progress);
                        }
                        progress.worked(1);
                    }
                    finally {
                        monitor_p.done();
                    }
                }
            });
        }
        catch (InvocationTargetException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("NewModelWizard.performFinish(..) _ ");
            loggerMessage.append(exception_p.getMessage());
            __logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception_p);
        }
        catch (InterruptedException exception_p) {
            StringBuilder loggerMessage = new StringBuilder("NewModelWizard.performFinish(..) _ ");
            loggerMessage.append(exception_p.getMessage());
            __logger.warn((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"), (Throwable)exception_p);
        }
        return true;
    }

    protected ProjectSessionCreationHelper createSessionCreationHelper() {
        return new ProjectSessionCreationHelper(this._mainPage.isEpbsSelected(), this._mainPage.isOpaSelected());
    }
}

