/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.fa.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;

public class FunctionPkgExt {
    private FunctionPkgExt() {
    }

    public static List<ExchangeCategory> getAllExchangeCategories(FunctionPkg functionPkg) {
        ArrayList<ExchangeCategory> list = new ArrayList<ExchangeCategory>(1);
        for (FunctionPkg pkg : FunctionPkgExt.getAllFunctionPkgs(functionPkg)) {
            list.addAll((Collection<ExchangeCategory>)pkg.getOwnedCategories());
        }
        return list;
    }

    public static List<FunctionPkg> getAllFunctionPkgs(BlockArchitecture arch) {
        return FunctionPkgExt.getAllFunctionPkgs(arch.getOwnedFunctionPkg());
    }

    public static List<FunctionPkg> getOwnedFunctionPkgs(FunctionPkg functionPkg) {
        ArrayList<FunctionPkg> containedFunctionPkgs = new ArrayList<FunctionPkg>();
        if (functionPkg instanceof OperationalActivityPkg) {
            containedFunctionPkgs.addAll((Collection<FunctionPkg>)((OperationalActivityPkg)functionPkg).getOwnedOperationalActivityPkgs());
        }
        if (functionPkg instanceof SystemFunctionPkg) {
            containedFunctionPkgs.addAll((Collection<FunctionPkg>)((SystemFunctionPkg)functionPkg).getOwnedSystemFunctionPkgs());
        }
        if (functionPkg instanceof LogicalFunctionPkg) {
            containedFunctionPkgs.addAll((Collection<FunctionPkg>)((LogicalFunctionPkg)functionPkg).getOwnedLogicalFunctionPkgs());
        }
        if (functionPkg instanceof PhysicalFunctionPkg) {
            containedFunctionPkgs.addAll((Collection<FunctionPkg>)((PhysicalFunctionPkg)functionPkg).getOwnedPhysicalFunctionPkgs());
        }
        return containedFunctionPkgs;
    }

    public static List<FunctionPkg> getAllFunctionPkgs(FunctionPkg functionPkg) {
        ArrayList<FunctionPkg> returnedList = new ArrayList<FunctionPkg>();
        if (functionPkg == null) {
            return returnedList;
        }
        returnedList.add(functionPkg);
        for (AbstractFunction aFunction : FunctionPkgExt.getOwnedFunctions(functionPkg)) {
            returnedList.addAll(ModelCache.getCache(FunctionExt::getAllFunctionPkgs, aFunction));
        }
        for (FunctionPkg aFunctionPkg : FunctionPkgExt.getOwnedFunctionPkgs(functionPkg)) {
            returnedList.addAll(FunctionPkgExt.getAllFunctionPkgs(aFunctionPkg));
        }
        return returnedList;
    }

    public static Collection<AbstractFunction> getFirstLevelAbstractFunctions(FunctionPkg container) {
        ArrayList<AbstractFunction> result = new ArrayList<AbstractFunction>();
        result.addAll(FunctionPkgExt.getOwnedFunctions(container));
        for (FunctionPkg pkg : FunctionPkgExt.getOwnedFunctionPkgs(container)) {
            result.addAll(FunctionPkgExt.getFirstLevelAbstractFunctions(pkg));
        }
        return result;
    }

    public static List<AbstractFunction> getOwnedFunctions(FunctionPkg functionPkg) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        if (functionPkg instanceof OperationalActivityPkg) {
            returnedList.addAll((Collection<AbstractFunction>)((OperationalActivityPkg)functionPkg).getOwnedOperationalActivities());
        }
        if (functionPkg instanceof SystemFunctionPkg) {
            returnedList.addAll((Collection<AbstractFunction>)((SystemFunctionPkg)functionPkg).getOwnedSystemFunctions());
        }
        if (functionPkg instanceof LogicalFunctionPkg) {
            returnedList.addAll((Collection<AbstractFunction>)((LogicalFunctionPkg)functionPkg).getOwnedLogicalFunctions());
        }
        if (functionPkg instanceof PhysicalFunctionPkg) {
            returnedList.addAll((Collection<AbstractFunction>)((PhysicalFunctionPkg)functionPkg).getOwnedPhysicalFunctions());
        }
        return returnedList;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(FunctionPkg functionPkg) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        if (functionPkg != null) {
            for (AbstractFunction aFunction : FunctionPkgExt.getOwnedFunctions(functionPkg)) {
                returnedList.addAll(ModelCache.getCache(FunctionExt::getAllAbstractFunctions, aFunction));
            }
            for (FunctionPkg aFunctionPkg : FunctionPkgExt.getOwnedFunctionPkgs(functionPkg)) {
                returnedList.addAll(ModelCache.getCache(FunctionPkgExt::getAllAbstractFunctions, aFunctionPkg));
            }
        }
        return returnedList;
    }
}

