/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.cache;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

public class PieIconCache {
    private static PieIconCache instance;
    private Map<List<RGBValues>, Image> colors2Icons = new HashMap<List<RGBValues>, Image>();
    private Comparator<RGBValues> colorComparator = (l, r) -> {
        if (l.getRed() != r.getRed()) {
            return l.getRed() - r.getRed();
        }
        if (l.getGreen() != r.getGreen()) {
            return l.getGreen() - r.getGreen();
        }
        return l.getBlue() - r.getBlue();
    };

    public static PieIconCache getInstance() {
        if (instance == null) {
            instance = new PieIconCache();
        }
        return instance;
    }

    private PieIconCache() {
    }

    public Image getIcon(List<RGBValues> colors) {
        if (!this.colors2Icons.containsKey(colors)) {
            colors.sort(this.colorComparator);
            Display display = Display.getDefault();
            Image canvas = new Image((Device)display, 16, 16);
            GC gc = new GC((Drawable)canvas);
            gc.setAntialias(1);
            gc.setAlpha(0);
            gc.fillRectangle(0, 0, 16, 16);
            gc.setAlpha(255);
            int diameter = 16;
            int radius = diameter / 2;
            int nbOfColors = colors.size();
            int angle = 360 / nbOfColors;
            Iterator<RGBValues> iterator = colors.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                RGBValues rgbValues = iterator.next();
                gc.setBackground(new Color(gc.getDevice(), rgbValues.getRed(), rgbValues.getGreen(), rgbValues.getBlue()));
                gc.fillArc(0, 0, diameter, diameter, i * angle, angle);
                ++i;
            }
            int j = 0;
            while (j < colors.size()) {
                gc.setForeground(new Color(gc.getDevice(), 255, 255, 255));
                int xCoord = radius + (int)Math.floor((double)radius * Math.cos(Math.toRadians((double)j * (double)angle)) + 0.5);
                int yCoord = radius + (int)Math.floor((double)radius * Math.sin(Math.toRadians((double)j * (double)angle)) + 0.5);
                gc.drawLine(radius, radius, xCoord, yCoord);
                ++j;
            }
            ImageData canvasData = canvas.getImageData();
            canvasData.alphaData = new byte[256];
            int idx = 0;
            while (idx < 256) {
                int coord = idx * 4 + 3;
                canvasData.alphaData[idx] = canvasData.data[coord];
                ++idx;
            }
            Image finalImage = new Image(gc.getDevice(), canvasData);
            canvas.dispose();
            gc.dispose();
            this.colors2Icons.put(colors, finalImage);
        }
        return this.colors2Icons.get(colors);
    }
}

