/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainReference;

public class InvolvementHierarchyContext {
    private List<FunctionalChainReference> hierarchyContext;
    private EdgeTarget edgeTarget;

    public InvolvementHierarchyContext(EdgeTarget edgeTarget) {
        this.edgeTarget = edgeTarget;
        this.hierarchyContext = this.computeHierarchyContext(edgeTarget);
    }

    protected InvolvementHierarchyContext(EdgeTarget edgeTarget, List<FunctionalChainReference> hierarchyContext) {
        this.edgeTarget = edgeTarget;
        this.hierarchyContext = hierarchyContext;
    }

    private List<FunctionalChainReference> computeHierarchyContext(EdgeTarget edgeTarget) {
        ArrayList<FunctionalChainReference> referenceHierarchy = new ArrayList<FunctionalChainReference>();
        DSemanticDecorator container = (DSemanticDecorator)edgeTarget.eContainer();
        while (container != null) {
            if (container.getTarget() instanceof FunctionalChainReference) {
                FunctionalChainReference functionalChainReference = (FunctionalChainReference)container.getTarget();
                referenceHierarchy.add(functionalChainReference);
            }
            container = (DSemanticDecorator)container.eContainer();
        }
        return referenceHierarchy;
    }

    public InvolvementHierarchyContext getParentHierarchyContext() {
        List<FunctionalChainReference> parentHierarchy = Collections.emptyList();
        int depth = this.getDepth();
        if (depth != 0) {
            parentHierarchy = this.hierarchyContext.subList(1, depth);
        }
        return new InvolvementHierarchyContext(this.edgeTarget, parentHierarchy);
    }

    public InvolvementHierarchyContext normalize(InvolvementHierarchyContext targetContext) {
        int targetContextDepth;
        int currentDepth = this.getDepth();
        int deltaDepth = currentDepth - (targetContextDepth = targetContext.getDepth());
        if (deltaDepth > 0) {
            List<FunctionalChainReference> normalizedHierarchyList = this.hierarchyContext.subList(deltaDepth, currentDepth);
            return new InvolvementHierarchyContext(this.edgeTarget, normalizedHierarchyList);
        }
        return this;
    }

    protected InvolvementHierarchyContext extractCommonContext(InvolvementHierarchyContext other) {
        int otherDepth;
        InvolvementHierarchyContext currentHierarchyContex = this;
        InvolvementHierarchyContext otherHierarchyContext = other;
        int thisDepth = currentHierarchyContex.getDepth();
        if (thisDepth > (otherDepth = otherHierarchyContext.getDepth())) {
            currentHierarchyContex = currentHierarchyContex.normalize(otherHierarchyContext);
        } else if (otherDepth > thisDepth) {
            otherHierarchyContext = otherHierarchyContext.normalize(currentHierarchyContex);
        }
        while (!currentHierarchyContex.equals(otherHierarchyContext)) {
            if (!currentHierarchyContex.isEmpty()) {
                currentHierarchyContex = currentHierarchyContex.getParentHierarchyContext();
            }
            if (otherHierarchyContext.isEmpty()) continue;
            otherHierarchyContext = otherHierarchyContext.getParentHierarchyContext();
        }
        return new InvolvementHierarchyContext(null, currentHierarchyContex.hierarchyContext);
    }

    public FunctionalChain extractCommonFunctionalChain(InvolvementHierarchyContext other) {
        InvolvementHierarchyContext commonHierarchy = this.extractCommonContext(other);
        if (commonHierarchy.isEmpty()) {
            return this.getRootFunctionalChain();
        }
        return this.getFunctionalChainOfFirstReference(commonHierarchy);
    }

    public int getDepth() {
        return this.hierarchyContext.size();
    }

    public boolean isEmpty() {
        return this.hierarchyContext.isEmpty();
    }

    public List<FunctionalChainReference> getReferences() {
        return this.hierarchyContext;
    }

    public List<FunctionalChainReference> getReferences(FunctionalChain endFunctionalChain) {
        ArrayList<FunctionalChainReference> references = new ArrayList<FunctionalChainReference>();
        for (FunctionalChainReference reference : this.hierarchyContext) {
            if (reference.getReferencedFunctionalChain() == endFunctionalChain) break;
            references.add(reference);
        }
        return references;
    }

    private FunctionalChain getFunctionalChainOfFirstReference(InvolvementHierarchyContext commonHierarchy) {
        return commonHierarchy.hierarchyContext.get(0).getReferencedFunctionalChain();
    }

    private FunctionalChain getRootFunctionalChain() {
        if (this.hierarchyContext.isEmpty()) {
            DSemanticDecorator container = (DSemanticDecorator)this.edgeTarget.eContainer();
            return (FunctionalChain)container.getTarget();
        }
        FunctionalChainReference lastHierarchyMember = this.hierarchyContext.get(this.getDepth() - 1);
        return (FunctionalChain)lastHierarchyMember.eContainer();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hierarchyContext == null ? 0 : this.hierarchyContext.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvolvementHierarchyContext)) {
            return false;
        }
        InvolvementHierarchyContext other = (InvolvementHierarchyContext)obj;
        return !(this.hierarchyContext == null ? other.hierarchyContext != null : !this.hierarchyContext.equals(other.hierarchyContext));
    }
}

