/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.internal.navigator.resources.actions.EditActionGroup;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaEditActionGroup
extends EditActionGroup {
    private Shell shell;
    private DeleteResourceAction deleteAction;

    public CapellaEditActionGroup(Shell shell) {
        super(shell);
        this.shell = shell;
        this.makeLocalActions();
    }

    public void fillActionBars(IActionBars actionBars) {
        super.fillActionBars(actionBars);
        IAction deleteActionHandler = actionBars.getGlobalActionHandler(ActionFactory.DELETE.getId());
        this.deleteAction.setEnabled(deleteActionHandler.isEnabled());
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.remove(this.deleteAction.getId());
        menu.appendToGroup("group.edit", (IAction)this.deleteAction);
    }

    protected void makeLocalActions() {
        IShellProvider shellProvider = new IShellProvider(){

            public Shell getShell() {
                return CapellaEditActionGroup.this.shell;
            }
        };
        this.deleteAction = new DeleteResourceAction(shellProvider){

            public void run() {
                List<IProject> hostingProjects;
                List selectedResources = this.getSelectedResources();
                IResource[] selectedResourcesArray = selectedResources.toArray(new IResource[selectedResources.size()]);
                boolean containsOnlyProjects = this.containsOnlyProjects(selectedResourcesArray);
                if (containsOnlyProjects) {
                    SessionHelper.closeUiSessions((List)selectedResources);
                }
                if ((hostingProjects = this.containsCapellaOrAirdResources(selectedResourcesArray)) != null) {
                    SessionHelper.closeUiSessions(hostingProjects);
                }
                super.run();
            }

            protected List<IProject> containsCapellaOrAirdResources(IResource[] selectedResourcesArray) {
                HashSet<IProject> hostingProjects = null;
                IResource[] iResourceArray = selectedResourcesArray;
                int n = selectedResourcesArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource currentResource = iResourceArray[n2];
                    String fileExtension = currentResource.getFileExtension();
                    if (1 == currentResource.getType() && (CapellaResourceHelper.isCapellaResource((IResource)currentResource) || "aird".equals(fileExtension) || "airdfragment".equals(fileExtension))) {
                        if (hostingProjects == null) {
                            hostingProjects = new HashSet<IProject>(1);
                        }
                        hostingProjects.add(currentResource.getProject());
                    }
                    ++n2;
                }
                return hostingProjects != null ? new ArrayList(hostingProjects) : null;
            }

            protected boolean containsOnlyProjects(IResource[] resources) {
                int types = this.getSelectedResourceTypes(resources);
                return types == 4;
            }

            protected int getSelectedResourceTypes(IResource[] resources) {
                int types = 0;
                int i = 0;
                while (i < resources.length) {
                    types |= resources[i].getType();
                    ++i;
                }
                return types;
            }
        };
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
    }

    public void updateActionBars() {
        super.updateActionBars();
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.deleteAction.selectionChanged(selection);
    }
}

