/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.sequence.description.SequenceDiagramDescription;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.menu.dynamic.DynamicActionProvider;
import org.polarsys.capella.core.menu.dynamic.DynamicCreationAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers.Messages;
import org.polarsys.capella.core.sirius.ui.actions.OpenRepresentationsAction;

public class DynamicOpenRepresentationContributionItem
extends CompoundContributionItem
implements IWorkbenchContribution {
    IServiceLocator locator = null;

    private void addScenariosFromCapabilitiesMenuEntries(AbstractCapability capa, IMenuManager menu, Session currentSession, Collection<Viewpoint> selectedViewpoints) {
        for (Viewpoint vp : selectedViewpoints) {
            for (RepresentationDescription representationDescription : vp.getOwnedRepresentations()) {
                SequenceDiagramDescription sdd;
                Collection descriptors;
                if (!(representationDescription instanceof SequenceDiagramDescription) || (descriptors = DialectManager.INSTANCE.getRepresentationDescriptors((RepresentationDescription)(sdd = (SequenceDiagramDescription)representationDescription), currentSession)) == null) continue;
                ArrayList ownedDescriptors = new ArrayList();
                EList lstScenarios = capa.getOwnedScenarios();
                for (Scenario scenario : lstScenarios) {
                    Collection repDescScenario = DialectManager.INSTANCE.getRepresentationDescriptors((EObject)scenario, currentSession);
                    ownedDescriptors.addAll(repDescScenario);
                }
                descriptors.retainAll(ownedDescriptors);
                for (DRepresentationDescriptor descriptor : descriptors) {
                    menu.add((IAction)new OpenRepresentationsAction(descriptor));
                }
            }
        }
    }

    public void initialize(IServiceLocator serviceLocator_p) {
        this.locator = serviceLocator_p;
    }

    protected IContributionItem[] getContributionItems() {
        IContributionItem item = new OpenRepresentationActionProvider().createContributionItem();
        return new IContributionItem[]{item};
    }

    class OpenRepresentationActionProvider
    extends DynamicActionProvider {
        private static final String CAPELLA_PROJECT_DIAGRAMS_MENU_ID = "capella.project.diagrams.menu";

        OpenRepresentationActionProvider() {
        }

        protected void fillContextMenu(IMenuManager menu, DynamicCreationAction action, String groupId) {
            ISelectionService service = (ISelectionService)DynamicOpenRepresentationContributionItem.this.locator.getService(ISelectionService.class);
            ISelection selection = service.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.createMenu(menu, (IStructuredSelection)selection);
            }
        }

        protected IContributionItem createContributionItem() {
            MenuManager subMenuManager = new MenuManager(Messages.OpenRepresentationActionProvider_OpenRepresentationAction_Title, CAPELLA_PROJECT_DIAGRAMS_MENU_ID);
            IActivityManager activityManager = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
            IIdentifier identifier = activityManager.getIdentifier(CAPELLA_PROJECT_DIAGRAMS_MENU_ID);
            if (identifier.isEnabled()) {
                this.fillContextMenu((IMenuManager)subMenuManager, this.dynamicAction, null);
            }
            return subMenuManager;
        }

        private void createMenu(IMenuManager menu, IStructuredSelection selection) {
            EObject firstSelectedEObject;
            Session currentSession;
            Object firstElement = selection.getFirstElement();
            if (firstElement instanceof EObject && (currentSession = SessionManager.INSTANCE.getSession(firstSelectedEObject = (EObject)firstElement)) != null) {
                this.createOpenDiagramMenu(firstSelectedEObject, menu, currentSession);
            }
        }

        private void createOpenDiagramMenu(EObject firstSelectedEObject, IMenuManager menu, Session currentSession) {
            Collection selectedViewpoints = currentSession.getSelectedViewpoints(false);
            Collection descriptions = DialectManager.INSTANCE.getAvailableRepresentationDescriptions(selectedViewpoints, firstSelectedEObject);
            if (!descriptions.isEmpty()) {
                for (RepresentationDescription description : descriptions) {
                    Collection descriptors = DialectManager.INSTANCE.getRepresentationDescriptors(description, currentSession);
                    if (descriptors == null) continue;
                    Collection ownedRep = DialectManager.INSTANCE.getRepresentationDescriptors(firstSelectedEObject, currentSession);
                    descriptors.retainAll(ownedRep);
                    for (DRepresentationDescriptor descriptor : descriptors) {
                        menu.add((IAction)new OpenRepresentationsAction(descriptor));
                    }
                }
                if (firstSelectedEObject instanceof AbstractCapability) {
                    DynamicOpenRepresentationContributionItem.this.addScenariosFromCapabilitiesMenuEntries((AbstractCapability)firstSelectedEObject, menu, currentSession, selectedViewpoints);
                }
            }
        }
    }
}

