/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.activities;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.scope.CompoundScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.IScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.RuleContainersScopeRetriever;
import org.polarsys.capella.core.transition.common.handlers.scope.RuleRootElementsScopeRetriever;
import org.polarsys.capella.core.transition.system.handlers.attachment.CapellaDefaultAttachmentHandler;
import org.polarsys.capella.core.transition.system.handlers.transformation.CapellaTransformationHandler;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class InitializeTransitionActivity
extends org.polarsys.capella.core.transition.common.activities.InitializeTransitionActivity {
    public static final String ID = "org.polarsys.capella.core.transition.system.activities.InitializeTransitionActivity";

    protected IStatus initializeContext(IContext context, ActivityParameters activityParams) {
        IStatus status = super.initializeContext(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeOptimizations(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        return status;
    }

    protected IStatus initializeScopeRetrieverHandlers(IContext context, CompoundScopeRetriever handler, ActivityParameters activityParams) {
        handler.addScopeRetriever((IScopeRetriever)new RuleRootElementsScopeRetriever(), context);
        handler.addScopeRetriever((IScopeRetriever)new RuleContainersScopeRetriever(), context);
        return super.initializeScopeRetrieverHandlers(context, handler, activityParams);
    }

    protected IStatus initializeOptimizations(IContext context, ActivityParameters activityParams) {
        return Status.OK_STATUS;
    }

    protected IStatus initializeTransitionSources(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SELECTION");
        context.put((Object)"TRANSITION_SOURCES", this.adaptSelection(selection));
        return Status.OK_STATUS;
    }

    protected Collection<EObject> adaptSelection(Collection<Object> selection) {
        return CapellaAdapterHelper.resolveSemanticObjects(selection);
    }

    protected IStatus initializeSource(IContext context, ActivityParameters activityParams) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (!selection.isEmpty()) {
            EObject source = (EObject)selection.toArray()[0];
            if (!(source instanceof CapellaElement)) {
                return new Status(4, Messages.Activity_Transition, "Input selection is not a CapellaElement");
            }
            this.ensureOpening(source);
        }
        return super.initializeSource(context, activityParams);
    }

    protected IStatus initializeTarget(IContext context, ActivityParameters activityParams) {
        Resource sourceResource = (Resource)context.get((Object)"_T_S_Res");
        if (sourceResource == null || sourceResource.getContents().isEmpty()) {
            return new Status(4, Messages.Activity_Transition, "Output model is invalid");
        }
        context.put((Object)"_T_T_Res", context.get((Object)"_T_S_Res"));
        context.put((Object)"TRANSITION_TARGET_EDITING_DOMAIN", context.get((Object)"TRANSITION_SOURCE_EDITING_DOMAIN"));
        context.put((Object)"_TTRo", context.get((Object)"_TSRo"));
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultAttachmentHandler() {
        return new CapellaDefaultAttachmentHandler();
    }

    protected IHandler createDefaultTransformationHandler() {
        return new CapellaTransformationHandler();
    }

    protected abstract IHandler createDefaultTraceabilityTargetHandler();

    protected void ensureOpening(EObject source) {
        Session session = SessionManager.INSTANCE.getSession(source);
        if (session == null && source instanceof CapellaElement) {
            SystemEngineering element = SystemEngineeringExt.getSystemEngineering((CapellaElement)((CapellaElement)source));
            EObject root = element.eContainer();
            root.eResource();
        }
    }
}

