/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.model.handler.command.BasicCapellaDeleteCommand;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.preferences.IDeletePreferences;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.decorators.ProtectedElementsDecorator;
import org.polarsys.capella.core.platform.sirius.ui.commands.DeleteRepresentationCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;
import org.polarsys.capella.core.ui.toolkit.dialogs.ConfirmDeleteCapellaElementDialog;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;

public class CapellaDeleteCommand
extends BasicCapellaDeleteCommand {
    private boolean preventProtectedElementsDeletion = false;
    private IStatus deletionStatus = Status.OK_STATUS;

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection) {
        this(executionManager, selection, true);
    }

    public CapellaDeleteCommand(EditingDomain editingDomain, Collection<?> selection, boolean confirmDelete) {
        this(null, selection, false, confirmDelete, true);
        this.editingDomain = editingDomain;
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction) {
        this(executionManager, selection, ensureTransaction, IDeletePreferences.INSTANCE.isConfirmationRequired(), true);
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction, boolean confirmDelete, boolean longOperationEvents) {
        super(executionManager, selection, ensureTransaction, confirmDelete, longOperationEvents);
    }

    public void setPreventProtectedElementsDeletion(boolean value) {
        this.preventProtectedElementsDeletion = value;
    }

    protected Command getDeleteRepresentationCommand(TransactionalEditingDomain editingDomain) {
        return new DeleteRepresentationCommand(editingDomain, RepresentationHelper.getAllRepresentationDescriptorsTargetedBy((Collection)this.getExpandedSelection()));
    }

    protected boolean isConfirmationRequired() {
        return IDeletePreferences.INSTANCE.isConfirmationRequired();
    }

    protected void showAbortDialogForControlledElementsToDelete(final Set<? extends EObject> controlledElementsToDelete) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImpactAnalysisDialog dialog = new ImpactAnalysisDialog(new ArrayList(controlledElementsToDelete), Messages.CapellaDeleteCommand_ConfirmLabel, Messages.CapellaDeleteCommand_ControlledElementsError_Message, 1, new String[]{org.polarsys.capella.common.ui.toolkit.dialogs.Messages.AbstractViewerDialog_OK_Title}, 3, false);
                dialog.open();
            }
        });
    }

    protected IStatus preDeleteChecks() {
        Set elementsToDelete = this.getAllElementsToDelete();
        if (this.preventProtectedElementsDeletion && !CapellaDeleteAction.canDelete(elementsToDelete)) {
            this.deletionStatus = new Status(4, "org.polarsys.capella.core.platform.sirius.ui.actions", Messages.CapellaDeleteCommand_ProtectedElementsError);
        } else {
            long nbRepresentations = elementsToDelete.stream().filter(DRepresentationDescriptor.class::isInstance).count();
            long nbSemanticElements = (long)elementsToDelete.size() - nbRepresentations;
            int status = 1;
            String messageNbSemanticElement = "";
            String messageNbRepresentation = "";
            messageNbSemanticElement = nbSemanticElements == 1L ? Messages.CapellaDeleteCommand_ConfirmDeletionWithOneSemanticElement : MessageFormat.format(Messages.CapellaDeleteCommand_ConfirmDeletionWithManySemanticElement, nbSemanticElements);
            if (nbRepresentations > 0L) {
                messageNbRepresentation = nbRepresentations == 1L ? Messages.CapellaDeleteCommand_ConfirmDeletionWithOneRepresentation : MessageFormat.format(Messages.CapellaDeleteCommand_ConfirmDeletionWithManyRepresentations, nbRepresentations);
                status = 2;
            }
            String message = MessageFormat.format(Messages.CapellaDeleteCommand_ConfirmDeletionQuestion, messageNbSemanticElement, messageNbRepresentation);
            this.deletionStatus = new Status(status, "org.polarsys.capella.core.platform.sirius.ui.actions", message);
        }
        return this.deletionStatus;
    }

    protected boolean confirmDeletion() {
        final Set elementsToDelete = this.getAllElementsToDelete();
        final ConfirmDeleteCapellaElementDialog confirmDeletionDialog = new ConfirmDeleteCapellaElementDialog(new ArrayList(elementsToDelete), true, this.getExpandedSelection().toArray()){

            protected IStatus getStatus() {
                return CapellaDeleteCommand.this.deletionStatus;
            }

            protected ILabelProvider createLabelProvider(ILabelProvider provider) {
                if (CapellaDeleteCommand.this.preventProtectedElementsDeletion && !ProtectedElementsDecorator.isEnabled()) {
                    return new DecoratingLabelProvider(provider, (ILabelDecorator)new ProtectedElementsDecorator(elementsToDelete));
                }
                return provider;
            }
        };
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                confirmDeletionDialog.open();
            }
        });
        return confirmDeletionDialog.getReturnCode() == 0;
    }

    public static boolean confirmDeletion(ExecutionManager manager, Collection<?> selection) {
        DryRun dr = new DryRun(manager, selection);
        dr.execute();
        return dr.proceed();
    }

    static class DryRun
    extends CapellaDeleteCommand {
        boolean proceed = false;

        public DryRun(ExecutionManager executionManager, Collection<?> selection) {
            super(executionManager, selection);
        }

        public boolean proceed() {
            return this.proceed;
        }

        public void doExecute() {
            this.proceed = true;
        }
    }
}

