/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.rules.interaction;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.CapellacommonFactory;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.EntityOperationalCapabilityInvolvement;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.topdown.handlers.transformation.TopDownTransformationHelper;
import org.polarsys.capella.core.transition.system.topdown.rules.common.InvolvementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class CapabilityInvolvementRule
extends InvolvementRule {
    protected EObject transformDirectElement(EObject element, IContext context) {
        if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element))) {
            EntityOperationalCapabilityInvolvement inv = (EntityOperationalCapabilityInvolvement)element;
            InvolverElement capability = inv.getInvolver();
            InvolvedElement entity = inv.getInvolved();
            if (TopDownTransformationHelper.getInstance(context).isTargetASystem((EObject)entity, context)) {
                ISelectionContext selectionContext = SelectionContextHandlerHelper.getHandler((IContext)context).getSelectionContext(context, "SC__T");
                Capability transformedCapability = (Capability)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement((EObject)capability, context, selectionContext);
                SystemComponent transformedSystemComponent = (SystemComponent)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement((EObject)entity, context, selectionContext);
                List involvements = transformedCapability.getOwnedCapabilityInvolvements().stream().filter(i -> i.getInvolved() == transformedSystemComponent).collect(Collectors.toList());
                if (!involvements.isEmpty()) {
                    return (EObject)involvements.get(0);
                }
            }
            return CtxFactory.eINSTANCE.createCapabilityInvolvement();
        }
        return CapellacommonFactory.eINSTANCE.createCapabilityRealizationInvolvement();
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)((CapellaElement)element))) {
            return CtxPackage.Literals.CAPABILITY__OWNED_CAPABILITY_INVOLVEMENTS;
        }
        return LaPackage.Literals.CAPABILITY_REALIZATION__OWNED_CAPABILITY_REALIZATION_INVOLVEMENTS;
    }

    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
        super.retrieveGoDeep(source, result, context);
        Involvement element = (Involvement)source;
        InvolvedElement targetElement = element.getInvolved();
        if (TopDownTransformationHelper.getInstance(context).isTracedInTarget((EObject)targetElement, context)) {
            result.add((EObject)targetElement);
        }
    }
}

