/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.topdown.rules.pa;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.transition.system.topdown.constants.Messages;
import org.polarsys.capella.core.transition.system.topdown.preferences.PreferenceHelper;
import org.polarsys.capella.core.transition.system.topdown.rules.cs.ComponentRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class PhysicalComponentRule
extends ComponentRule {
    protected EClass getSourceType() {
        return PaPackage.Literals.PHYSICAL_COMPONENT;
    }

    public EClass getTargetType(EObject element, IContext context) {
        return EpbsPackage.Literals.CONFIGURATION_ITEM;
    }

    @Override
    public IStatus transformRequired(EObject element, IContext context) {
        IStatus transformRequired = super.transformRequired(element, context);
        if (!PreferenceHelper.getInstance().transitionPC2CIWhileScenarioTransition()) {
            return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, Messages.PC2CI_Preferences);
        }
        if (((PhysicalComponent)element).isActor()) {
            return new Status(2, org.polarsys.capella.core.transition.common.constants.Messages.Activity_Transformation, NLS.bind((String)Messages.PC2CI_Actor, (Object)((PhysicalComponent)element).getName()));
        }
        return transformRequired;
    }

    @Override
    protected void retrieveComponentGoDeep(EObject source_p, List<EObject> result_p, IContext context_p) {
        this.retrieveRepresentingPartitions(source_p, result_p, context_p);
    }

    protected void updateElement(EObject element, EObject result, IContext context) {
        super.updateElement(element, result, context);
        ((ConfigurationItem)result).setKind(this.getConfigurationItemKind());
    }

    private ConfigurationItemKind getConfigurationItemKind() {
        String configurationItemKind = PreferenceHelper.getInstance().getConfigurationItemKind();
        return ConfigurationItemKind.getByName((String)configurationItemKind);
    }
}

