/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.actions;

import java.util.List;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.platform.sirius.clipboard.actions.AbstractCopyPasteAction;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.CapellaDiagramCopyCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;

public class CapellaDiagramCopyAction
extends AbstractCopyPasteAction {
    public void run(IAction action_p) {
        if (this.isInLabelEdition()) {
            this.getEditingTextWidget().copy();
        } else if (this.isOnNoteContent()) {
            this.copyTextToSystemClipboard(this.getSelectedNoteContentFigure().getText());
        } else {
            List<? extends View> toCopy = this.getCopyPasteSelection();
            if (toCopy.size() > 0) {
                CapellaDiagramCopyCommand cmd = new CapellaDiagramCopyCommand(toCopy);
                MiscUtil.transactionallyExecute(toCopy, (ICommand)cmd);
            }
        }
    }

    @Override
    protected boolean isEnabled() {
        boolean result;
        if (this.isInLabelEdition()) {
            result = this.getEditingTextWidget().getSelectionText().length() > 0;
        } else if (this.isOnNoteContent()) {
            result = true;
        } else if (this.isInSequenceDiagram()) {
            result = false;
        } else {
            List<? extends View> selection = this.getCopyPasteSelection();
            result = !selection.isEmpty();
            for (View view : selection) {
                if (!(view instanceof Diagram)) continue;
                result = false;
                break;
            }
        }
        return result;
    }
}

