/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.operations;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.XMLSave;
import org.eclipse.emf.ecore.xmi.impl.XMISaveImpl;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyObjects;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.SavingEMFResource;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.IdentifiedElement;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.common.utils.ReflectUtil;

public class CapellaSavingEMFResource
extends SavingEMFResource {
    private static final Logger logger = Logger.getLogger((String)CapellaSavingEMFResource.class.getName());
    private Collection excludedObjects;

    public CapellaSavingEMFResource(URI uri, String encoding, Map defaultSaveOptions, Map copy2ObjectMap, CopyObjects copyObjects, IClipboardSupport clipboardOperationHelper) {
        super(uri, encoding, defaultSaveOptions, copy2ObjectMap, copyObjects, clipboardOperationHelper);
        this.excludedObjects = clipboardOperationHelper.getExcludedCopyObjects(copyObjects.totalCopyObjects);
    }

    public String getID(EObject eObject) {
        String id = super.getID(eObject);
        Resource eResource = eObject.eResource();
        if (id == null && eResource != null && !(eResource instanceof XMLResource)) {
            id = eResource.getURIFragment(eObject);
        }
        return id;
    }

    protected XMLSave createXMLSave() {
        return new XMISaveImpl(this.createXMLHelper()){

            protected void saveElement(InternalEObject o, EStructuralFeature f) {
                this.saveElement((EObject)o, f);
            }

            protected void saveElement(EObject o, EStructuralFeature f) {
                if (CapellaSavingEMFResource.this.excludedObjects.contains(o)) {
                    return;
                }
                super.saveElement(o, f);
            }

            protected boolean shouldSaveFeature(EObject o, EStructuralFeature f) {
                if (CapellaSavingEMFResource.this.shouldNotSaveFeature(o, f)) {
                    return false;
                }
                return super.shouldSaveFeature(o, f);
            }

            protected int sameDocMany(EObject o, EStructuralFeature f) {
                InternalEList values = (InternalEList)this.helper.getValue(o, f);
                if (values.isEmpty()) {
                    return 0;
                }
                Iterator i = values.basicIterator();
                while (i.hasNext()) {
                    InternalEObject value = (InternalEObject)i.next();
                    if (!value.eIsProxy() && CapellaSavingEMFResource.this.reflectIsInSavingResource((EObject)value)) continue;
                    return 2;
                }
                return 1;
            }

            protected int sameDocSingle(EObject o, EStructuralFeature f) {
                InternalEObject value = (InternalEObject)this.helper.getValue(o, f);
                if (value == null) {
                    return 0;
                }
                if (value.eIsProxy()) {
                    return 2;
                }
                return CapellaSavingEMFResource.this.reflectIsInSavingResource((EObject)value) ? 1 : 2;
            }
        };
    }

    protected boolean shouldNotSaveFeature(EObject o, EStructuralFeature f) {
        return this.isSiriusElementAndUidFeature(o, f) || o instanceof DSemanticDecorator && f instanceof EReference && !((EReference)f).isContainment() && ((EReference)f).getEType() instanceof EClass && (ViewpointPackage.eINSTANCE.getDSemanticDecorator().isSuperTypeOf((EClass)((EReference)f).getEType()) || DiagramPackage.eINSTANCE.getEdgeTarget().isSuperTypeOf((EClass)((EReference)f).getEType()));
    }

    private boolean isSiriusElementAndUidFeature(EObject o, EStructuralFeature f) {
        return o instanceof IdentifiedElement && ViewpointPackage.eINSTANCE.getIdentifiedElement_Uid().equals(f);
    }

    boolean reflectIsInSavingResource(EObject eObject) {
        boolean result = false;
        try {
            result = (Boolean)ReflectUtil.invokeInvisibleMethod((Object)((Object)this), (String)"isInSavingResource", (Object[])new Object[]{eObject});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

