/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.viewpoint.DRefreshable;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public final class SiriusUtil {
    private SiriusUtil() {
    }

    public static UniqueEList<AbstractNodeMapping> fiterOutImported(Collection<AbstractNodeMapping> mappings_p) {
        UniqueEList result = new UniqueEList(mappings_p);
        for (AbstractNodeMapping mapping : mappings_p) {
            if (!(mapping instanceof AbstractMappingImport)) continue;
            AbstractMappingImport importMapping = (AbstractMappingImport)mapping;
            NodeMapping imported = null;
            if (importMapping instanceof NodeMappingImport) {
                imported = ((NodeMappingImport)importMapping).getImportedMapping();
            } else if (importMapping instanceof ContainerMappingImport) {
                imported = ((ContainerMappingImport)importMapping).getImportedMapping();
            }
            if (imported == null) continue;
            result.remove((Object)imported);
        }
        return result;
    }

    public static UniqueEList<AbstractNodeMapping> getApplicableMappingsIn(DRefreshable graphicalContext_p) {
        UniqueEList<AbstractNodeMapping> result = null;
        if (graphicalContext_p instanceof DDiagram) {
            result = SiriusUtil.getApplicableMappingsInDiagram((DDiagram)graphicalContext_p);
        } else if (graphicalContext_p instanceof DNodeContainer) {
            result = SiriusUtil.getApplicableMappingsInContainer((DNodeContainer)graphicalContext_p);
        }
        return result;
    }

    public static UniqueEList<AbstractNodeMapping> getApplicableMappingsInDiagram(DDiagram diagram_p) {
        UniqueEList result = new UniqueEList();
        DiagramDescription desc = diagram_p.getDescription();
        result.addAll((Collection)desc.getContainerMappings());
        result.addAll((Collection)desc.getNodeMappings());
        for (DiagramElementMapping reusedMapping : desc.getReusedMappings()) {
            if (!(reusedMapping instanceof AbstractNodeMapping)) continue;
            result.add((Object)((AbstractNodeMapping)reusedMapping));
        }
        EList layers = LayerHelper.getAllLayers((DiagramDescription)desc);
        for (Layer layer : layers) {
            result.addAll((Collection)layer.getContainerMappings());
            result.addAll((Collection)layer.getNodeMappings());
            for (DiagramElementMapping reusedMapping : layer.getReusedMappings()) {
                if (!(reusedMapping instanceof AbstractNodeMapping)) continue;
                result.add((Object)((AbstractNodeMapping)reusedMapping));
            }
        }
        return result;
    }

    public static UniqueEList<AbstractNodeMapping> getApplicableMappingsInContainer(DNodeContainer container_p) {
        UniqueEList result = new UniqueEList();
        ContainerMapping mapping = container_p.getActualMapping();
        result.addAll((Collection)mapping.getReusedNodeMappings());
        result.addAll((Collection)mapping.getSubNodeMappings());
        result.addAll((Collection)mapping.getReusedContainerMappings());
        result.addAll((Collection)mapping.getSubContainerMappings());
        return result;
    }

    public static DDiagram getDiagram(EObject context_p) {
        DDiagram result = null;
        if (context_p instanceof DDiagram) {
            result = (DDiagram)context_p;
        } else if (context_p instanceof DDiagramElement) {
            result = ((DDiagramElement)context_p).getParentDiagram();
        }
        return result;
    }

    public static DDiagram getOwningDiagram(EObject element_p) {
        if (element_p == null) {
            return null;
        }
        if (element_p instanceof DDiagram) {
            return (DDiagram)element_p;
        }
        return SiriusUtil.getOwningDiagram(element_p.eContainer());
    }

    public static EObject getSemanticElement(Object source_p) {
        if (source_p == null) {
            return null;
        }
        Object elt = source_p;
        if (elt instanceof EditPart) {
            elt = ((EditPart)elt).getModel();
        }
        if (elt instanceof View) {
            elt = ((View)elt).getElement();
        }
        if (elt instanceof DSemanticDecorator) {
            elt = ((DSemanticDecorator)elt).getTarget();
        }
        if (elt instanceof EObject) {
            return (EObject)elt;
        }
        return null;
    }

    public static boolean isBorderedNode(DNode siriusNode_p) {
        boolean result = false;
        NodeMapping mapping = siriusNode_p.getActualMapping();
        if (mapping != null) {
            result = mapping.eContainmentFeature() == DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings();
        }
        return result;
    }

    public static boolean isInSequenceDiagram(EObject context_p) {
        return SiriusUtil.getDiagram(context_p) instanceof SequenceDDiagram;
    }

    public static boolean layoutIsConstrained(EObject context_p) {
        return SiriusUtil.isInSequenceDiagram(context_p);
    }

    public static boolean refreshDiagram(DDiagramElement diagramElement_p) {
        return SiriusUtil.refreshDiagram(SiriusUtil.getDiagram((EObject)diagramElement_p));
    }

    public static boolean refreshDiagram(DDiagram diagram_p) {
        boolean result = false;
        if (diagram_p != null) {
            DialectManager.INSTANCE.refresh((DRepresentation)diagram_p, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        return result;
    }

    public static String getContextDiagram(EObject element) {
        DDiagram diagram = SiriusUtil.getOwningDiagram(element);
        if (diagram != null) {
            return diagram.getDescription().getName();
        }
        return null;
    }
}

