/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.fillhandle.config;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.InternalCopyDataCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.FillHandleLayerPainter;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleCursorAction;
import org.eclipse.nebula.widgets.nattable.fillhandle.action.FillHandleDragMode;
import org.eclipse.nebula.widgets.nattable.fillhandle.command.FillHandlePasteCommandHandler;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleEventMatcher;
import org.eclipse.nebula.widgets.nattable.fillhandle.event.FillHandleMarkupListener;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.ui.action.ClearCursorAction;
import org.eclipse.nebula.widgets.nattable.ui.action.NoOpMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;

public class FillHandleConfiguration
extends AbstractLayerConfiguration<NatTable> {
    protected SelectionLayer selectionLayer;
    protected FillHandleLayerPainter painter;
    protected InternalCellClipboard clipboard;

    public FillHandleConfiguration(SelectionLayer selectionLayer) {
        if (selectionLayer == null) {
            throw new IllegalArgumentException("SelectionLayer can not be null");
        }
        this.selectionLayer = selectionLayer;
    }

    @Override
    public void configureTypedLayer(NatTable natTable) {
        this.clipboard = natTable.getInternalCellClipboard();
        this.painter = new FillHandleLayerPainter();
        this.selectionLayer.setLayerPainter(this.painter);
        this.selectionLayer.addLayerListener(new FillHandleMarkupListener(this.selectionLayer));
        this.selectionLayer.registerCommandHandler(new InternalCopyDataCommandHandler(this.selectionLayer, this.clipboard));
        this.selectionLayer.registerCommandHandler(new FillHandlePasteCommandHandler(this.selectionLayer, this.clipboard));
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        FillHandleEventMatcher matcher = new FillHandleEventMatcher(this.painter);
        uiBindingRegistry.registerFirstMouseMoveBinding(matcher, new FillHandleCursorAction());
        uiBindingRegistry.registerMouseMoveBinding(new MouseEventMatcher(), new ClearCursorAction());
        uiBindingRegistry.registerFirstMouseDragMode(matcher, new FillHandleDragMode(this.selectionLayer, this.clipboard));
        uiBindingRegistry.registerFirstMouseDownBinding(matcher, new NoOpMouseAction());
    }
}

