/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.IPageChangeProvider;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.EclipseNodePreferencesChangeListener;
import org.polarsys.capella.core.commands.preferences.service.FieldEditorPropertyPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.IConfigurableFieldEditorPreferencePage;
import org.polarsys.capella.core.commands.preferences.service.UserProfileModeEnum;

public abstract class ConfigurableFieldEditorPreferencePage
extends FieldEditorPropertyPreferencePage
implements IConfigurableFieldEditorPreferencePage,
IPageChangeProvider {
    private String pageId;
    private ListenerList pageChangedListener = new ListenerList();
    public static Map<FieldEditor, Composite> EXPERT_FIELD_EDITORS = new HashMap<FieldEditor, Composite>(0);
    public static List<Composite> COMPOSITE_FIELD_EDITORS = new ArrayList<Composite>(0);

    protected ConfigurableFieldEditorPreferencePage(int style) {
        super(style);
    }

    protected ConfigurableFieldEditorPreferencePage(String id) {
        super(0x800000);
        this.pageId = id;
    }

    @Override
    public void init(IWorkbench workbench) {
        this.addPageChangedListener(new EclipseNodePreferencesChangeListener());
    }

    protected void addField(FieldEditor editor, UserProfileModeEnum userProfileModeEnum, Composite parent) {
        if (UserProfileModeEnum.Expert.equals((Object)userProfileModeEnum) && parent != null && !parent.isDisposed()) {
            EXPERT_FIELD_EDITORS.put(editor, parent);
            editor.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"), parent);
            parent.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"));
        }
        super.addField(editor);
    }

    protected String getPageId() {
        return this.pageId;
    }

    protected void addField(FieldEditor editor, UserProfileModeEnum userProfileModeEnum, Composite parent, Class scope) {
        if (UserProfileModeEnum.Expert.equals((Object)userProfileModeEnum) && parent != null && !parent.isDisposed()) {
            EXPERT_FIELD_EDITORS.put(editor, parent);
            editor.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"), parent);
            parent.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"));
        } else if (parent != null) {
            editor.setEnabled(true, parent);
            parent.setEnabled(true);
        }
        super.addField(editor);
    }

    @Override
    protected void addField(FieldEditor editor) {
        this.addField(editor, UserProfileModeEnum.User, null);
    }

    protected void setEnable(Composite parent, UserProfileModeEnum userMode) {
        parent.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled("com.thalsegroup.mde.capella.preferences.user.expert.profile"));
        COMPOSITE_FIELD_EDITORS.add(parent);
    }

    protected void createFieldEditors() {
    }

    protected void checkState() {
        Object[] lisObjects;
        super.checkState();
        Object[] objectArray = lisObjects = this.pageChangedListener.getListeners();
        int n = lisObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            EclipseNodePreferencesChangeListener listener = (EclipseNodePreferencesChangeListener)object;
            listener.pageChanged(new PageChangedEvent((IPageChangeProvider)this, this.getSelectedPage()));
            ++n2;
        }
    }

    public Object getSelectedPage() {
        return this.getFieldEditorParent();
    }

    public void addPageChangedListener(IPageChangedListener listener) {
        this.pageChangedListener.add((Object)listener);
    }

    public void removePageChangedListener(IPageChangedListener listener) {
        this.pageChangedListener.remove((Object)listener);
    }

    public void enablePreferencesPage(boolean isEnable) {
        int i = 0;
        while (i < COMPOSITE_FIELD_EDITORS.size()) {
            Composite composite = COMPOSITE_FIELD_EDITORS.get(i);
            if (composite != null && composite.isDisposed()) {
                COMPOSITE_FIELD_EDITORS.remove(i);
            } else if (composite != null) {
                composite.setEnabled(isEnable);
                composite.pack();
            }
            ++i;
        }
        Set<FieldEditor> fields = EXPERT_FIELD_EDITORS.keySet();
        for (Object e : fields) {
            FieldEditor fieldEditorPreferencePage = (FieldEditor)e;
            Composite composite = EXPERT_FIELD_EDITORS.get(fieldEditorPreferencePage);
            if (composite != null && composite.isDisposed()) {
                EXPERT_FIELD_EDITORS.remove(composite);
                continue;
            }
            if (composite == null) continue;
            fieldEditorPreferencePage.setEnabled(isEnable, composite);
        }
        Iterator<Map.Entry<FieldEditor, Composite>> iterator = EXPERT_FIELD_EDITORS.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<FieldEditor, Composite> pairs = iterator.next();
            Composite composite = pairs.getValue();
            if (composite != null && composite.isDisposed()) {
                EXPERT_FIELD_EDITORS.remove(composite);
            } else if (composite != null) {
                composite.setEnabled(isEnable);
            }
            iterator.remove();
        }
    }
}

