/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import org.eclipse.core.runtime.CoreException;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.AbstractItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.commands.preferences.util.IUserProfileDescriptor;
import org.polarsys.capella.core.preferences.commands.exceptions.ItemExistsException;

public class UserProfileDescriptor
extends AbstractItemDescriptor
implements IUserProfileDescriptor {
    public UserProfileDescriptor(String userProfileModeId, String userProfileModeName) {
        try {
            this.assertNotNull(userProfileModeId, "org.polarsys.capella.core.preferences");
            this.assertNotNull(userProfileModeName, "org.polarsys.capella.core.preferences");
            PreferencesItemsRegistry.getInstance().registerUserProfile(this);
            ConfigurabilityPreferences.setInstanceScopePreferenceItem(userProfileModeId, ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled(userProfileModeId));
            ConfigurabilityPreferences.save();
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.setError(e);
        }
        catch (ItemExistsException exception_p) {
            StringBuilder stringBuilder = new StringBuilder("UserProfileDescriptor.UserProfileDescriptor(..) _ ");
        }
    }

    @Override
    public String getName() {
        return "User Profile";
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    public String getId() {
        return "com.thalsegroup.mde.capella.preferences.user.expert.profile";
    }

    @Override
    public String getPluginId() {
        return "org.polarsys.capella.core.preferences";
    }

    @Override
    public String getDescription() {
        return "Expert User";
    }
}

