/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.viewers.categories;

import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.diff.IPresenceDifference;
import org.eclipse.emf.diffmerge.ui.EMFDiffMergeUIPlugin;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractSideRelatedDifferenceCategory;
import org.eclipse.swt.graphics.Image;

public class ThreeWayOriginCategory
extends AbstractSideRelatedDifferenceCategory {
    public static final String ID_LEFT = "Technical.ThreeWayOrigin.Left";
    public static final String ID_RIGHT = "Technical.ThreeWayOrigin.Right";

    public ThreeWayOriginCategory(boolean sideIsLeft_p) {
        super(sideIsLeft_p);
    }

    @Override
    public boolean covers(IDifference<?> difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (difference_p instanceof IPresenceDifference) {
            IPresenceDifference presence = (IPresenceDifference)difference_p;
            Role sideRole = node_p.getRoleForSide(this.isLeftSide());
            Role presenceRole = presence.getPresenceRole();
            result = presenceRole == sideRole && !presence.isAlignedWithAncestor() || presenceRole != sideRole && presence.isAlignedWithAncestor();
        }
        return result;
    }

    @Override
    public String getDescription(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.ThreeWayOriginCategory_DescriptionLeft : Messages.ThreeWayOriginCategory_DescriptionRight;
        return result;
    }

    @Override
    public String getID() {
        return this.isLeftSide() ? ID_LEFT : ID_RIGHT;
    }

    @Override
    public Image getImage(EMFDiffNode node_p) {
        EMFDiffMergeUIPlugin.ImageID imageID = this.isLeftSide() ? EMFDiffMergeUIPlugin.ImageID.OUT_STAT : EMFDiffMergeUIPlugin.ImageID.INC_STAT;
        return node_p.getResourceManager().getStandaloneOverlay(imageID);
    }

    @Override
    public String getText(EMFDiffNode node_p) {
        String result = this.isLeftSide() ? Messages.ThreeWayOriginCategory_TextLeft : Messages.ThreeWayOriginCategory_TextRight;
        return result;
    }

    @Override
    public boolean isApplicable(EMFDiffNode node_p) {
        return node_p.isThreeWay();
    }
}

