/*******************************************************************************
 * Copyright (c) 2006, 2020 THALES GLOBAL SERVICES.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.information.validation.operation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;

import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

/**
 * Maximum number of Parameter with the Direction "Return" can not be more than one
 */
public class OperationReturnParameter extends AbstractValidationRule {
  /**
   * @see org.eclipse.emf.validation.AbstractModelConstraint#validate(org.eclipse.emf.validation.IValidationContext)
   */
  @Override
  public IStatus validate(IValidationContext ctx) {
    EObject eObj = ctx.getTarget();
    EMFEventType eType = ctx.getEventType();

    if (eType == EMFEventType.NULL) {
      if (eObj instanceof Operation) {
        Operation operation = (Operation) eObj;

        int count = 0;
        for (Parameter param : operation.getOwnedParameters()) {
          if (param.getDirection().getLiteral().equals(ParameterDirection.RETURN.toString()))
            count++;
        }
        if (count > 1) {
          return ctx.createFailureStatus(new Object[] { operation.getName() });
        }
      }
    }
    return ctx.createSuccessStatus();
  }
}
