/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import java.util.HashMap;
import org.eclipse.jface.viewers.ILabelProvider;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.ICompoundProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyGroup;
import org.polarsys.capella.common.flexibility.wizards.policy.IPolicifiedRendererContext;
import org.polarsys.capella.common.flexibility.wizards.policy.IRendererPolicy;
import org.polarsys.capella.common.flexibility.wizards.schema.IGroupRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IPropertyRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.schema.IRenderers;
import org.polarsys.capella.common.flexibility.wizards.ui.DefaultLabelProvider;

public class RendererContext
implements IRendererContext,
PropertyChangeListener,
IPolicifiedRendererContext {
    ILabelProvider labelProvider;
    IPropertyContext _propertyContext;
    IRenderers _renderers;
    HashMap<IProperty, IPropertyRenderer> _properties2renderers;
    HashMap<IPropertyRenderer, IProperty> _renderers2properties;
    HashMap<IPropertyGroup, IGroupRenderer> _groups2renderers;
    HashMap<IGroupRenderer, IPropertyGroup> _renderers2groups;
    HashMap<String, Object> _parameters = new HashMap();
    IRendererPolicy policy;

    @Override
    public void addRendererPolicy(IRendererPolicy policy) {
        this.policy = policy;
    }

    public RendererContext(IRenderers renderers, IPropertyContext context) {
        this.setPropertyContext(context);
        this._renderers = renderers;
        this._properties2renderers = new HashMap(0);
        this._renderers2properties = new HashMap(0);
        this._groups2renderers = new HashMap(0);
        this._renderers2groups = new HashMap(0);
        this.labelProvider = new DefaultLabelProvider();
    }

    @Override
    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    @Override
    public void setPropertyContext(IPropertyContext propertyContext) {
        if (this._propertyContext != null && this._propertyContext != propertyContext) {
            this._propertyContext.unregisterListener((PropertyChangeListener)this);
        }
        HashMap<IProperty, IProperty> map = new HashMap<IProperty, IProperty>();
        if (this._propertyContext != propertyContext) {
            if (this._propertyContext != null) {
                for (IProperty property : this._propertyContext.getProperties().getAllItems()) {
                    for (IProperty property2 : propertyContext.getProperties().getAllItems()) {
                        if (!property.getId().equals(property2.getId()) || property.equals(property2)) continue;
                        map.put(property, property2);
                        this._properties2renderers.put(property2, this._properties2renderers.get(property));
                        this._renderers2properties.put(this._properties2renderers.get(property2), property2);
                        this.updatePropertyRenderer(property2.getId());
                    }
                }
            }
            this._propertyContext = propertyContext;
        }
        if (this._propertyContext != null) {
            this._propertyContext.registerListener((PropertyChangeListener)this);
        }
    }

    public void update(PropertyChangedEvent event) {
        String id = event.getProperty().getId();
        this.updatePropertyRenderer(id);
    }

    protected void updatePropertyRenderer(String id) {
        IProperty property = this.getPropertyContext().getProperties().getProperty(id);
        if (property != null) {
            IPropertyRenderer renderer = this.getRenderer(property);
            if (renderer != null) {
                renderer.updatedValue(property, this, this.getPropertyContext().getCurrentValue(property));
            }
            if (property instanceof ICompoundProperty) {
                String[] stringArray = ((ICompoundProperty)property).getRelatedProperties();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String idSub = stringArray[n2];
                    this.updatePropertyRenderer(idSub);
                    ++n2;
                }
            }
        }
    }

    @Override
    public IProperty getProperty(IPropertyRenderer renderer) {
        return this._renderers2properties.get(renderer);
    }

    @Override
    public IPropertyRenderer getRenderer(IProperty property) {
        if (!this._properties2renderers.containsKey(property)) {
            IPropertyRenderer renderer = this._renderers.createRenderer(property);
            if (renderer == null) {
                renderer = this.createDefaultRenderer(property);
            }
            this._properties2renderers.put(property, renderer);
            this._renderers2properties.put(renderer, property);
        }
        return this._properties2renderers.get(property);
    }

    public IPropertyRenderer createDefaultRenderer(IProperty property) {
        if (this.policy != null && this.policy.match(property)) {
            return this.policy.createRenderer(property);
        }
        return null;
    }

    @Override
    public IGroupRenderer getRenderer(IPropertyGroup propertyGroup) {
        if (!this._groups2renderers.containsKey(propertyGroup)) {
            IGroupRenderer renderer = this._renderers.createRenderer(propertyGroup);
            if (renderer == null) {
                renderer = this.createDefaultRenderer(propertyGroup);
            }
            this._groups2renderers.put(propertyGroup, renderer);
            this._renderers2groups.put(renderer, propertyGroup);
        }
        return this._groups2renderers.get(propertyGroup);
    }

    public IGroupRenderer createDefaultRenderer(IPropertyGroup propertyGroup) {
        if (this.policy != null && this.policy.match(propertyGroup)) {
            return this.policy.createRenderer(propertyGroup);
        }
        return null;
    }

    @Override
    public IPropertyGroup getPropertyGroup(IGroupRenderer renderer) {
        return this._renderers2groups.get(renderer);
    }

    @Override
    public IRenderers getRenderers() {
        return this._renderers;
    }

    @Override
    public IPropertyContext getPropertyContext() {
        return this._propertyContext;
    }

    @Override
    public Object getParameter(String id) {
        return this._parameters.get(id);
    }

    @Override
    public void putParameter(String id, Object value) {
        this._parameters.put(id, value);
    }
}

