/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.viewers;

import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.services.helper.ViewerHelper;
import org.polarsys.capella.common.ui.toolkit.viewers.AbstractContextMenuFiller;
import org.polarsys.capella.common.ui.toolkit.viewers.FieldsViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.Messages;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.PatternFilter;

public abstract class AbstractRegExpViewer
extends FieldsViewer {
    private Viewer _clientViewer;
    private Menu _contextMenu;
    private MenuManager _contextMenuManager;
    private AbstractContextMenuFiller _contextMenuManagerFiller;
    private PatternFilter _filter;
    private Text _regExpText;

    public AbstractRegExpViewer(Composite parent) {
        super(parent, 0);
    }

    public AbstractRegExpViewer(Composite parent, boolean isMultipleSelection) {
        super(parent, isMultipleSelection);
    }

    public AbstractRegExpViewer(Composite parent, boolean isMultipleSelection, int style, int viewerExpandLevel) {
        super(parent, isMultipleSelection, style, viewerExpandLevel);
    }

    public void addFilter(ViewerFilter filter) {
        Viewer clientViewer = this.getClientViewer();
        if (clientViewer instanceof StructuredViewer && !((Object)((Object)this._filter)).equals(filter)) {
            ((StructuredViewer)clientViewer).addFilter(filter);
        }
    }

    @Override
    protected void createControl(Composite parent) {
        super.createControl(parent);
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        this._filter = this.createPatternFilter();
        this.createFilterText(parent);
        this._clientViewer = this.doClientViewer(parent);
        this.handleViewerFilterAttachment(this._filter);
        if (this._clientViewer != null) {
            GridData gdData = new GridData();
            gdData.verticalAlignment = 4;
            gdData.horizontalAlignment = 4;
            gdData.grabExcessHorizontalSpace = true;
            gdData.grabExcessVerticalSpace = true;
            this._clientViewer.getControl().setLayoutData((Object)gdData);
            this.installContextMenu();
        }
    }

    protected void createFilterText(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText(Messages.getString("AbstractRegExpViewer.group.label"));
        GridData gdData = new GridData(768);
        group.setLayoutData((Object)gdData);
        GridLayout layout = new GridLayout(1, true);
        group.setLayout((Layout)layout);
        Label regExpLabel = new Label((Composite)group, 0);
        gdData = new GridData(768);
        regExpLabel.setText(Messages.getString("AbstractRegExpViewer.help.label"));
        regExpLabel.setLayoutData((Object)gdData);
        this._regExpText = new Text((Composite)group, 2048);
        gdData = new GridData(768);
        this._regExpText.setLayoutData((Object)gdData);
        this._regExpText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AbstractRegExpViewer.this._filter.setPattern(((Text)event.widget).getText());
                AbstractRegExpViewer.this.handlePatternApplied(AbstractRegExpViewer.this.getClientViewer());
            }
        });
    }

    protected PatternFilter createPatternFilter() {
        return new PatternFilter(){

            @Override
            protected boolean isParentMatch(Viewer viewer, Object parentElement, Object element) {
                if (viewer instanceof AbstractTreeViewer) {
                    return super.isParentMatch(viewer, parentElement, element);
                }
                return false;
            }
        };
    }

    @Override
    public void dispose() {
        super.dispose();
        this._filter = null;
        this._contextMenuManagerFiller = null;
        if (this._regExpText != null && !this._regExpText.isDisposed()) {
            this._regExpText.dispose();
            this._regExpText = null;
        }
        if (this._contextMenu != null && !this._contextMenu.isDisposed()) {
            this._contextMenu.dispose();
            this._contextMenu = null;
        }
        if (this._contextMenuManager != null) {
            this._contextMenuManager.dispose();
        }
    }

    protected abstract Viewer doClientViewer(Composite var1);

    public Viewer getClientViewer() {
        return this._clientViewer;
    }

    public MenuManager getContextMenuManager() {
        return this._contextMenuManager;
    }

    public ViewerFilter getFilter() {
        return this._filter;
    }

    @Override
    public Object getInput() {
        return null;
    }

    protected void handlePatternApplied(Viewer clientViewer) {
        if (clientViewer instanceof StructuredViewer) {
            ViewerHelper.refresh((StructuredViewer)clientViewer);
        }
    }

    protected void handleViewerFilterAttachment(ViewerFilter filter) {
        if (this._clientViewer != null && this._clientViewer instanceof StructuredViewer) {
            ((StructuredViewer)this._clientViewer).addFilter(filter);
        }
    }

    protected void installContextMenu() {
        Control control = this._clientViewer.getControl();
        this._contextMenuManager = new MenuManager("#Popup");
        this._contextMenuManager.setRemoveAllWhenShown(true);
        this._contextMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (AbstractRegExpViewer.this._contextMenuManagerFiller != null) {
                    AbstractRegExpViewer.this._contextMenuManagerFiller.fillMenuManager((IMenuManager)AbstractRegExpViewer.this._contextMenuManager, AbstractRegExpViewer.this._clientViewer.getSelection());
                }
            }
        });
        this._contextMenu = this._contextMenuManager.createContextMenu(control);
        control.setMenu(this._contextMenu);
    }

    public void removeFilter(ViewerFilter filter) {
        Viewer clientViewer = this.getClientViewer();
        if (clientViewer instanceof StructuredViewer && !((Object)((Object)this._filter)).equals(filter)) {
            ((StructuredViewer)clientViewer).removeFilter(filter);
        }
    }

    public void setContextMenuManagerFiller(AbstractContextMenuFiller contextMenuManagerFiller) {
        this._contextMenuManagerFiller = contextMenuManagerFiller;
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this._regExpText != null && !this._regExpText.isDisposed()) {
            this._regExpText.setEnabled(enabled);
        }
        if (this._clientViewer != null && !this._clientViewer.getControl().isDisposed()) {
            this._clientViewer.getControl().setEnabled(enabled);
        }
    }

    public void setFilters(ViewerFilter[] filters) {
        Viewer clientViewer = this.getClientViewer();
        if (clientViewer instanceof StructuredViewer) {
            ViewerFilter[] filts = new ViewerFilter[filters.length + 1];
            System.arraycopy(filters, 0, filts, 0, filters.length);
            filts[filters.length] = this._filter;
            ((StructuredViewer)clientViewer).setFilters(filts);
        }
    }

    @Override
    public void setInput(Object input) {
        Viewer clientViewer = this.getClientViewer();
        if (clientViewer != null) {
            clientViewer.setInput(input);
        }
    }
}

