/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.FilteredModelScope;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.core.util.locations.BasicReferenceLocation;
import org.eclipse.emf.diffmerge.patterns.templates.engine.ext.ModellerSemanticRuleProvider;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.MultiStorageChoiceDialog;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemContext;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.AssociationPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalContext;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalContext;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;

public class CapellaRuleProvider
extends ModellerSemanticRuleProvider {
    private final Map<EClass, IReferenceLocation> _perTypeLocations = new HashMap<EClass, IReferenceLocation>();
    private final Collection<IReferenceLocation> _predefinedLocations = new HashSet<IReferenceLocation>();
    protected static final List<EReference> NON_DEPENDENCY_REFERENCES = Arrays.asList(ModellingcorePackage.eINSTANCE.getAbstractType_AbstractTypedElements(), CapellacorePackage.eINSTANCE.getType_TypedElements());

    public void adjustScope(FilteredModelScope scope_p, boolean extend_p) {
        boolean changed;
        while (changed = this.adjustScopeNonRec(scope_p, extend_p)) {
        }
    }

    private boolean adjustScopeNonRec(FilteredModelScope scope_p, boolean extend_p) {
        return extend_p ? this.extendScopeNonRec(scope_p) : this.reduceScopeNonRec(scope_p);
    }

    public boolean appliesTo(Object context_p) {
        boolean result = context_p instanceof CapellaElement;
        if (!result) {
            Resource resource = null;
            if (context_p instanceof Resource) {
                resource = (Resource)context_p;
            } else if (context_p instanceof EObject) {
                resource = ((EObject)context_p).eResource();
            }
            result = CapellaResourceHelper.isCapellaResource((Resource)resource);
        }
        return result;
    }

    private EObject deriveLinkContainer(EObject source_p, EObject target_p) {
        EObject result = null;
        EObject sourceElement = this.getLinkDerivationReferenceElement(source_p);
        EObject targetElement = this.getLinkDerivationReferenceElement(target_p);
        if (sourceElement != null && targetElement != null) {
            result = ModelsUtil.getCommonAncestor((EObject)sourceElement, (EObject)targetElement);
        }
        return result;
    }

    public boolean deriveOwnership(EObject element_p, Object context_p) {
        boolean result = super.deriveOwnership(element_p, context_p);
        if (!result) {
            ActivityEdge casted;
            EObject container = null;
            EReference containment = null;
            if (element_p instanceof ActivityEdge) {
                casted = (ActivityEdge)element_p;
                if (casted.getSource() != null && casted.getTarget() != null && (container = this.deriveLinkContainer((EObject)casted.getSource(), (EObject)casted.getTarget())) instanceof AbstractFunction) {
                    containment = FaPackage.eINSTANCE.getAbstractFunction_OwnedFunctionalExchanges();
                }
            } else if (element_p instanceof ComponentExchange) {
                casted = (ComponentExchange)element_p;
                container = this.deriveLinkContainer((EObject)casted.getSource(), (EObject)casted.getTarget());
                if (container instanceof Component) {
                    containment = FaPackage.eINSTANCE.getAbstractFunctionalBlock_OwnedComponentExchanges();
                }
            } else if (element_p instanceof PhysicalLink) {
                PhysicalLink exchange = (PhysicalLink)element_p;
                EList ends = exchange.getLinkEnds();
                if (2 == ends.size() && (container = this.deriveLinkContainer((EObject)ends.get(0), (EObject)ends.get(1))) instanceof Component) {
                    containment = CsPackage.eINSTANCE.getComponent_OwnedPhysicalLinks();
                }
            } else if (element_p instanceof Association) {
                EObject typeContainer;
                AbstractType type;
                casted = (Association)element_p;
                FOrderedSet allEndProperties = new FOrderedSet();
                allEndProperties.addAll(casted.getOwnedMembers());
                allEndProperties.addAll(casted.getNavigableMembers());
                if (!allEndProperties.isEmpty() && (type = ((Property)allEndProperties.get(0)).getAbstractType()) != null && (typeContainer = type.eContainer()) instanceof AssociationPkg) {
                    container = typeContainer;
                    containment = InformationPackage.eINSTANCE.getAssociationPkg_OwnedAssociations();
                }
            } else if (element_p instanceof AbstractType) {
                AbstractTypedElement typedElement;
                List containments;
                casted = (AbstractType)element_p;
                EList typedElements = Collections.emptyList();
                try {
                    TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)((EObject)context_p));
                    Resource holdingResource = HoldingResourceHelper.getHoldingResource((TransactionalEditingDomain)domain);
                    HoldingResourceHelper.attachToHoldingResource((EObject)casted, (Resource)holdingResource);
                    typedElements = casted.getAbstractTypedElements();
                    holdingResource.getContents().remove((Object)casted);
                }
                catch (Exception domain) {
                    // empty catch block
                }
                if (typedElements.size() == 1 && (containments = this.getReferencesForAddition(container = (typedElement = (AbstractTypedElement)typedElements.get(0)).eContainer(), element_p.eClass(), true, true)).size() == 1) {
                    containment = (EReference)containments.get(0);
                }
            }
            if (container != null && containment != null) {
                BasicReferenceLocation location = new BasicReferenceLocation(container, containment);
                try {
                    LocationsUtil.add((IReferenceLocation)location, (EObject)element_p);
                    result = true;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public Boolean enforceOwnership(Collection<? extends EObject> roots_p, Object context_p) {
        FOrderedSet derivables = new FOrderedSet();
        for (EObject eObject : roots_p) {
            if (eObject.eContainer() != null) continue;
            if (this.ownershipMightBeDerived(eObject)) {
                derivables.add((Object)eObject);
                continue;
            }
            Boolean success = this.enforceOwnershipByPrompt(eObject, context_p, true, this._perTypeLocations, this._predefinedLocations);
            if (Boolean.TRUE.equals(success)) continue;
            return success;
        }
        int n = derivables.size() - 1;
        for (EObject derivable : new FArrayList((Collection)derivables, null)) {
            if (!(derivable instanceof PhysicalLink)) continue;
            derivables.move(n, (Object)derivable);
        }
        for (EObject derivable : derivables) {
            Boolean success;
            boolean derived = this.deriveOwnership(derivable, context_p);
            if (derived || Boolean.TRUE.equals(success = this.enforceOwnershipByPrompt(derivable, context_p, true, this._perTypeLocations, this._predefinedLocations))) continue;
            return success;
        }
        return Boolean.TRUE;
    }

    private Boolean enforceOwnershipByPrompt(EObject element_p, Object context_p, boolean allowCancel_p, Map<EClass, IReferenceLocation> perTypeLocations_p, Collection<IReferenceLocation> predefinedLocations_p) {
        Boolean result = Boolean.TRUE;
        boolean done = false;
        IReferenceLocation registeredLocation = perTypeLocations_p.get(element_p.eClass());
        if (registeredLocation != null && this.supportsAdditionOf(registeredLocation, element_p)) {
            LocationsUtil.add((IReferenceLocation)registeredLocation, (EObject)element_p);
            done = true;
        } else {
            Iterator<IReferenceLocation> it = predefinedLocations_p.iterator();
            while (it.hasNext() && !done) {
                IReferenceLocation predefinedLocation = it.next();
                if (!this.supportsAdditionOf(predefinedLocation, element_p)) continue;
                LocationsUtil.add((IReferenceLocation)predefinedLocation, (EObject)element_p);
                done = true;
            }
        }
        while (!done) {
            EObject container;
            List<EReference> containments;
            IReferenceLocation location = null;
            boolean proceed = true;
            MultiStorageChoiceDialog.MultiStorageKind storageKind = MultiStorageChoiceDialog.MultiStorageKind.CURRENT_ONLY;
            List candidateContainers = this.getPossibleContainersInContext(context_p, Collections.singleton(element_p));
            if (candidateContainers.size() == 1 && (containments = this.getReferencesForElementAddition(container = (EObject)candidateContainers.get(0), element_p, true, true)).size() == 1) {
                EReference containment = containments.get(0);
                location = new BasicReferenceLocation(container, containment);
            }
            if (location == null) {
                MultiStorageChoiceDialog dialog = new MultiStorageChoiceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, candidateContainers, element_p);
                int answer = dialog.open();
                boolean bl = proceed = answer == 0;
                if (proceed) {
                    location = dialog.getChoice();
                    storageKind = dialog.getStorageKind();
                }
            }
            if (proceed) {
                if (location == null) continue;
                LocationsUtil.add(location, (EObject)element_p);
                done = true;
                switch (storageKind) {
                    case ALL_SIMILAR: {
                        perTypeLocations_p.put(element_p.eClass(), location);
                        break;
                    }
                    case ALL_COMPATIBLE: {
                        predefinedLocations_p.add(location);
                    }
                }
                continue;
            }
            if (!allowCancel_p) continue;
            return null;
        }
        return result;
    }

    private List<EReference> getReferencesForElementAddition(EObject element_p, EObject value_p, boolean nonErasing_p, boolean containmentOnly_p) {
        ArrayList<EReference> result = new ArrayList<EReference>();
        EList candidates = containmentOnly_p ? element_p.eClass().getEAllContainments() : element_p.eClass().getEAllReferences();
        for (EReference candidate : candidates) {
            if (!this.supportsAdditionOf(element_p, candidate, value_p, nonErasing_p)) continue;
            result.add(candidate);
        }
        return Collections.unmodifiableList(result);
    }

    private boolean extendScopeNonRec(FilteredModelScope scope_p) {
        FOrderedSet toAdd = new FOrderedSet();
        for (EObject root : scope_p.getContents()) {
            toAdd.addAll(this.getAdditionalRelevantElements(root, (IModelScope)scope_p));
            TreeIterator it = scope_p.getAllContents(root);
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                toAdd.addAll(this.getAdditionalRelevantElements(current, (IModelScope)scope_p));
            }
        }
        boolean result = false;
        for (EObject rootToAdd : ModelsUtil.getRoots((Collection)toAdd)) {
            if (scope_p.covers(rootToAdd)) continue;
            scope_p.add(rootToAdd, true);
            result = true;
        }
        return result;
    }

    private Collection<? extends EObject> getAdditionalRelevantElements(EObject element_p, IModelScope scope_p) {
        AbstractTypedElement casted;
        FOrderedSet result = new FOrderedSet();
        if (element_p instanceof AbstractTypedElement && (casted = (AbstractTypedElement)element_p).getAbstractType() != null) {
            result.add(casted.getAbstractType());
        }
        if (element_p instanceof Allocation && (casted = (Allocation)element_p).getTargetElement() != null) {
            result.add(casted.getTargetElement());
        }
        if (element_p instanceof Association) {
            casted = (Association)element_p;
            result.addAll(casted.getNavigableMembers());
        }
        if (element_p instanceof ActivityNode) {
            casted = (ActivityNode)element_p;
            for (ActivityEdge incoming : casted.getIncoming()) {
                if (!scope_p.covers((EObject)incoming.getSource())) continue;
                result.add(incoming);
            }
            for (ActivityEdge outgoing : casted.getOutgoing()) {
                if (!scope_p.covers((EObject)outgoing.getTarget())) continue;
                result.add(outgoing);
            }
        }
        if (element_p instanceof ComponentPort) {
            casted = (ComponentPort)element_p;
            for (AbstractInformationFlow flow : casted.getInformationFlows()) {
                if (!scope_p.covers((EObject)flow.getSource()) || !scope_p.covers((EObject)flow.getTarget())) continue;
                result.add(flow);
            }
        }
        if (element_p instanceof PhysicalPort) {
            casted = (PhysicalPort)element_p;
            for (PhysicalLink link : casted.getInvolvedLinks()) {
                FOrderedSet remaining = new FOrderedSet((Collection)link.getLinkEnds(), null);
                remaining.remove(casted);
                if (remaining.isEmpty() || !scope_p.covers((EObject)remaining.get(0))) continue;
                result.add(link);
            }
        }
        if (element_p instanceof SequenceMessage) {
            casted = (SequenceMessage)element_p;
            result.add(casted.getSendingEnd());
            result.add(casted.getSendingEnd().getEvent());
            result.add(casted.getReceivingEnd());
            result.add(casted.getReceivingEnd().getEvent());
        }
        if (element_p instanceof InstanceRole && (casted = (InstanceRole)element_p).getRepresentedInstance() != null) {
            result.add(casted.getRepresentedInstance());
        }
        return Collections.unmodifiableList(result);
    }

    public List<EStructuralFeature> getDefaultOptionalMergeFeatures() {
        return Collections.singletonList(ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name());
    }

    public Collection<EObject> getElementsToRename(Collection<? extends EObject> elements_p) {
        Collection<? extends EObject> candidates = Collections.unmodifiableCollection(elements_p);
        FOrderedSet result = new FOrderedSet(candidates, null);
        if (!candidates.isEmpty() && this.isSingletonComponentDriven(candidates.iterator().next())) {
            for (EObject eObject : candidates) {
                Part part;
                AbstractType type;
                if (!(eObject instanceof Part) || !((type = (part = (Part)eObject).getAbstractType()) instanceof Component) || !result.contains(type)) continue;
                result.remove(eObject);
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    private EObject getLinkDerivationReferenceElement(EObject element_p) {
        ComponentExchangeEnd end;
        Object result = element_p instanceof ComponentExchangeEnd ? ((end = (ComponentExchangeEnd)element_p).getPart() != null ? end.getPart() : end.getPort()) : (element_p instanceof PhysicalLinkEnd ? ((end = (PhysicalLinkEnd)element_p).getPart() != null ? end.getPart() : end.getPort()) : element_p);
        return result.eContainer();
    }

    public EAttribute getNameAttribute(EObject element_p) {
        EAttribute result = element_p instanceof AbstractNamedElement ? ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name() : super.getNameAttribute(element_p);
        return result;
    }

    public List<EStructuralFeature> getOptionalMergeFeatures() {
        return Arrays.asList(ModellingcorePackage.eINSTANCE.getAbstractNamedElement_Name(), CapellacorePackage.eINSTANCE.getCapellaElement_Description(), CapellacorePackage.eINSTANCE.getCapellaElement_Summary());
    }

    public Collection<EObject> getRootsForPatternInclusion(EObject context_p) {
        FArrayList result = new FArrayList();
        EObject root = EcoreUtil.getRootContainer((EObject)context_p);
        if (root instanceof Project) {
            result.addAll(((Project)root).getOwnedModelRoots());
        } else {
            result.add(root);
        }
        return Collections.unmodifiableCollection(result);
    }

    private boolean isMeaningfulWithin(EObject element_p, IModelScope scope_p) {
        AbstractTrace casted;
        if (element_p instanceof EnumerationPropertyValue) {
            return false;
        }
        FOrderedSet mustBeIncluded = new FOrderedSet();
        if (element_p instanceof AbstractTrace) {
            casted = (AbstractTrace)element_p;
            mustBeIncluded.add(casted.getSourceElement());
            mustBeIncluded.add(casted.getTargetElement());
        } else if (element_p instanceof FunctionalExchange) {
            casted = (FunctionalExchange)element_p;
            mustBeIncluded.add(casted.getSource());
            mustBeIncluded.add(casted.getTarget());
        } else if (element_p instanceof ComponentExchange) {
            ComponentExchange connection = (ComponentExchange)element_p;
            InformationsExchanger source = connection.getSource();
            if (source instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPort());
            } else {
                mustBeIncluded.add(source);
            }
            InformationsExchanger target = connection.getTarget();
            if (target instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPort());
            } else {
                mustBeIncluded.add(target);
            }
        } else if (element_p instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)element_p;
            for (AbstractPhysicalLinkEnd end : physicalLink.getLinkEnds()) {
                if (end instanceof PhysicalLinkEnd) {
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPart());
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPort());
                    continue;
                }
                mustBeIncluded.add(end);
            }
        }
        for (EObject current : mustBeIncluded) {
            if (current != null && scope_p.covers(current)) continue;
            return false;
        }
        return true;
    }

    public boolean isMergeDependency(EObject element_p) {
        return element_p instanceof DataType;
    }

    private boolean isSingletonComponentDriven(EObject element_p) {
        boolean result = false;
        if (element_p instanceof ModelElement) {
            result = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isSingletonComponentsDriven((EObject)element_p));
        }
        return result;
    }

    public boolean ownershipMightBeDerived(EObject element_p) {
        return super.ownershipMightBeDerived(element_p) || element_p instanceof ActivityEdge || element_p instanceof ComponentExchange || element_p instanceof PhysicalLink || element_p instanceof Association || element_p instanceof Component;
    }

    private boolean reduceScopeNonRec(FilteredModelScope scope_p) {
        FOrderedSet toDelete = new FOrderedSet();
        for (EObject root : scope_p.getContents()) {
            TreeIterator it = scope_p.getAllContents(root);
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                if (this.isMeaningfulWithin(current, (IModelScope)scope_p)) continue;
                toDelete.add(current);
                it.prune();
            }
        }
        for (EObject rootToDelete : ModelsUtil.getRoots((Collection)toDelete)) {
            scope_p.removeFromScope(rootToDelete, true);
        }
        return !toDelete.isEmpty();
    }

    public boolean supportsAdditionOf(EObject element_p, EReference reference_p, EObject value_p, boolean nonErasing_p) {
        boolean result = super.supportsAdditionOf(element_p, reference_p, value_p, nonErasing_p);
        if (result && value_p instanceof Part) {
            Part part = (Part)value_p;
            Type type = part.getType();
            if (type instanceof AbstractActor) {
                result = type instanceof Actor ? element_p instanceof SystemContext : (type instanceof LogicalActor ? element_p instanceof LogicalContext : element_p instanceof PhysicalContext);
            } else if (type instanceof LogicalComponent) {
                result = element_p instanceof LogicalContext || element_p instanceof LogicalComponent;
            } else if (type instanceof PhysicalComponent) {
                result = element_p instanceof PhysicalContext || element_p instanceof PhysicalComponent;
            }
        }
        return result;
    }

    protected boolean supportsAdditionOf(EObject element_p, EReference reference_p, EClass valueType_p, boolean nonErasing_p) {
        boolean result = super.supportsAdditionOf(element_p, reference_p, valueType_p, nonErasing_p);
        if (result) {
            EClass elementClass = element_p.eClass();
            if (PaPackage.eINSTANCE.getPhysicalFunction().isSuperTypeOf(valueType_p)) {
                result = PaPackage.eINSTANCE.getPhysicalFunction().isSuperTypeOf(elementClass) || PaPackage.eINSTANCE.getPhysicalFunctionPkg().isSuperTypeOf(elementClass);
            } else if (LaPackage.eINSTANCE.getLogicalFunction().isSuperTypeOf(valueType_p)) {
                result = LaPackage.eINSTANCE.getLogicalFunction().isSuperTypeOf(elementClass) || LaPackage.eINSTANCE.getLogicalFunctionPkg().isSuperTypeOf(elementClass);
            } else if (CtxPackage.eINSTANCE.getSystemFunction().isSuperTypeOf(valueType_p)) {
                result = CtxPackage.eINSTANCE.getSystemFunction().isSuperTypeOf(elementClass) || CtxPackage.eINSTANCE.getSystemFunctionPkg().isSuperTypeOf(elementClass);
            }
        }
        return result;
    }

    private boolean supportsAdditionOf(IReferenceLocation location_p, EObject value_p) {
        return this.supportsAdditionOf(location_p.getElement(), location_p.getReference(), value_p, true);
    }

    public boolean isDependency(EReference reference_p) {
        return !reference_p.isDerived() && !NON_DEPENDENCY_REFERENCES.contains(reference_p);
    }

    public boolean isApplicableTo(EObject obj_p) {
        return true;
    }

    public boolean canBeAutomaticallyMerged(EObject element_p) {
        return false;
    }

    public EObject getAutomaticMergeTarget(EObject element_p, Object targetScope_p) {
        return null;
    }

    public String getPrefixText(EObject element_p) {
        return "";
    }

    public void initializeTargetScope(IFeaturedModelScope referenceScope_p, IFeaturedModelScope targetScope_p) {
    }

    public boolean isAllowedToBeRoot(EObject obj_p) {
        return obj_p instanceof Project;
    }

    public boolean isAutomaticallyUpdatedDiagram(Object diagram_p) {
        return false;
    }

    public void postPatternApplication(IPatternApplication application_p, Collection<EObject> additions_p, Collection<IDifference> merges_p) {
        if (!additions_p.isEmpty()) {
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)additions_p.iterator().next());
            HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)domain);
        }
    }

    public void reset() {
        this._perTypeLocations.clear();
        this._predefinedLocations.clear();
    }
}

