/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.capella.validation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.diffmerge.patterns.capella.validation.Checker;
import org.eclipse.emf.diffmerge.patterns.capella.validation.ValidationUtil;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.ModelElement;

public class PatternConformanceConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx_p) {
        IStatus result = ctx_p.createSuccessStatus();
        EObject eo = ctx_p.getTarget();
        if (eo instanceof ModelElement) {
            ModelElement target = (ModelElement)eo;
            Diagnostic diag = Checker.getInstance().check(target);
            if (diag.getSeverity() != 0) {
                IModelEnvironmentUI me = PatternsUIPlugin.getDefault().getModelEnvironmentUI();
                String sTarget = me.getText((Object)target);
                String suffix = this.buildSingleDiagnosticMessage(diag);
                result = ctx_p.createFailureStatus(new Object[]{sTarget, suffix});
            }
        }
        return result;
    }

    protected String buildSingleDiagnosticMessage(Diagnostic root_p) {
        String[] messages = ValidationUtil.buildDiagnosticMessages(root_p, false);
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        String[] stringArray = messages;
        int n = messages.length;
        int n2 = 0;
        while (n2 < n) {
            String msg = stringArray[n2];
            if (first) {
                first = false;
            } else {
                builder.append(" - ");
            }
            builder.append(msg);
            ++n2;
        }
        return builder.toString();
    }
}

