/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.extension.migration.egf;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenJDKLevel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenResourceKind;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.converter.util.ConverterUtil;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterManager;
import org.polarsys.capella.common.extension.migration.egf.AbstractGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGenModelGenerator
extends AbstractGenerator {
    private static final Logger _logger = Logger.getLogger((String)AbstractGenModelGenerator.class.getPackage().getName());
    protected static final String MODEL_FOLDER = "/model/";
    private ModelImporter _modelImporter;
    private IPath _inputPath;
    private String _modelPluginId;
    private String _basePackage;
    private IPath _genModelPath;
    private IPath _genModelContainerPath;
    private String _rootExtendsInterface;
    private String _rootExtendsClass;
    private GenJDKLevel _jdkComplianceLevel;
    private String _modelDirectory;
    private GenResourceKind _resourcetype;
    private String _implementationPackageSuffix;
    private String _interfacePackageSuffix;
    private String _metadataPackageSuffix;
    private String _utilityPackageSuffix;
    private boolean _operationReflection;

    protected abstract ModelImporter createModelImporter();

    private String getModelDirectory() {
        StringBuffer projectLocationPath = new StringBuffer("/");
        projectLocationPath.append(this._modelPluginId).append("/").append(this._modelDirectory).append("/");
        return projectLocationPath.toString();
    }

    private GenModel createGenModel(Monitor monitor) {
        GenModel genModel = null;
        try {
            try {
                ModelImporter modelImporter = this.getModelImporter();
                if (this._modelDirectory != null) {
                    modelImporter.setModelPluginDirectory(this.getModelDirectory());
                }
                modelImporter.prepareGenModelAndEPackages(monitor);
                genModel = modelImporter.getGenModel();
                this.setGenModelParameters(genModel);
                try {
                    modelImporter.saveGenModelAndEPackages(monitor);
                }
                catch (Exception exception) {
                    StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.generateGenModelWithImporter(..) _ ");
                    _logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
                    genModel = null;
                }
            }
            catch (Exception exception) {
                genModel = null;
                Diagnostic errorDiagnostic = ConverterUtil.createErrorDiagnostic((Throwable)exception, (boolean)true);
                if (errorDiagnostic != null) {
                    this.handleDiagnostic(errorDiagnostic, "Error in genmodel creation");
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return genModel;
    }

    private void handleReferencedPackages(ModelImporter modelImporter, Monitor monitor) {
        ArrayList<GenModel> externalGenModels = new ArrayList<GenModel>(0);
        this.addExternalGenModels(externalGenModels);
        List packages = modelImporter.getEPackages();
        for (EPackage currentPackage : packages) {
            GenPackage externalGenPackage = null;
            Iterator iteratorOverExternalGenModels = externalGenModels.iterator();
            while (iteratorOverExternalGenModels.hasNext() && externalGenPackage == null) {
                GenModel currentExternalGenModel = (GenModel)iteratorOverExternalGenModels.next();
                Iterator externalGenPackages = currentExternalGenModel.getGenPackages().iterator();
                while (externalGenPackages.hasNext() && externalGenPackage == null) {
                    GenPackage currentGenPackage = (GenPackage)externalGenPackages.next();
                    EPackage ecorePackage = currentGenPackage.getEcorePackage();
                    if (currentPackage != ecorePackage && !currentPackage.getNsURI().equals(ecorePackage.getNsURI())) continue;
                    externalGenPackage = currentGenPackage;
                }
            }
            if (externalGenPackage != null) {
                modelImporter.getReferencedGenPackages().add(externalGenPackage);
                modelImporter.getReferenceGenPackageConvertInfo(externalGenPackage).setValidReference(true);
                continue;
            }
            modelImporter.getEPackageConvertInfo(currentPackage).setConvert(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setGenModelParameters(GenModel genModel) {
        genModel.setContainmentProxies(true);
        if (this._rootExtendsInterface != null) {
            genModel.setRootExtendsInterface(this._rootExtendsInterface);
        }
        if (this._rootExtendsClass != null) {
            genModel.setRootExtendsClass(this._rootExtendsClass);
        }
        if (this._jdkComplianceLevel != null) {
            genModel.setComplianceLevel(this._jdkComplianceLevel);
        }
        genModel.setModelPluginID(this._modelPluginId);
        genModel.setOperationReflection(this._operationReflection);
        genModel.setNonNLSMarkers(true);
        if (this._modelDirectory != null) {
            genModel.setModelDirectory(this.getModelDirectory());
        }
        genPackages = genModel.getAllGenPackagesWithClassifiers();
        for (GenPackage genPackage : genPackages) {
            block7: {
                if (this._resourcetype != null) {
                    genPackage.setResource(this._resourcetype);
                }
                ePackage = genPackage.getEcorePackage();
                container = ePackage.getESuperPackage();
                suffix = "";
                if (container != null) ** GOTO lbl25
                this.setPackageParameters(genPackage, this._basePackage);
                break block7;
lbl-1000:
                // 1 sources

                {
                    suffix = "." + container.getName() + suffix;
                    container = container.getESuperPackage();
lbl25:
                    // 2 sources

                    ** while (container != null)
                }
            }
            this.setPackageParameters(genPackage, String.valueOf(this._basePackage) + suffix);
        }
    }

    private void setPackageParameters(GenPackage genPackage2, String basePackage) {
        genPackage2.setBasePackage(basePackage);
        if (this._implementationPackageSuffix != null) {
            genPackage2.setClassPackageSuffix(this._implementationPackageSuffix);
        }
        if (this._interfacePackageSuffix != null) {
            genPackage2.setInterfacePackageSuffix(this._interfacePackageSuffix);
        }
        if (this._metadataPackageSuffix != null) {
            genPackage2.setMetaDataPackageSuffix(this._metadataPackageSuffix);
        }
        if (this._utilityPackageSuffix != null) {
            genPackage2.setUtilityPackageSuffix(this._utilityPackageSuffix);
        }
    }

    public GenModel execute(Monitor monitor) {
        GenModel genModel = null;
        try {
            ModelImporter modelImporter = this.getModelImporter();
            boolean result = this.adjustAttributes(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
            if (result) {
                this.adjustModelImporter(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
                Diagnostic diagnostic = modelImporter.checkGenModelFileName();
                result = this.handleDiagnostic(diagnostic, "Check genmodel file name failed");
                if (result) {
                    modelImporter.getGenModelResourceSet();
                    result = this.handleEPackages(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
                    if (result) {
                        genModel = this.createGenModel(CodeGenUtil.createMonitor((Monitor)monitor, (int)1));
                    }
                }
            }
        }
        catch (RuntimeException exception) {
            StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.execute(..) _ ");
            _logger.error((Object)loggerMessage.toString(), (Throwable)exception);
            genModel = null;
        }
        return genModel;
    }

    protected ModelImporter getModelImporter() {
        if (this._modelImporter == null) {
            this._modelImporter = this.createModelImporter();
        }
        return this._modelImporter;
    }

    protected boolean adjustAttributes(Monitor monitor) {
        try {
            monitor.beginTask("", 1);
            this._genModelContainerPath = this.getGenModelContainer();
            this._genModelPath = this.getGenModelPath();
        }
        finally {
            monitor.done();
        }
        return true;
    }

    protected abstract IPath getGenModelPath();

    protected void adjustModelImporter(Monitor monitor) {
        try {
            monitor.beginTask("", 1);
            ModelImporter modelImporter = this.getModelImporter();
            ModelImporterDescriptor modelImporterDescriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.getModelImporter().getID());
            modelImporter.getFileExtensions().addAll(modelImporterDescriptor.getExtensions());
            modelImporter.setModelProjectName(this._modelPluginId);
            modelImporter.setModelPluginID(this._modelPluginId);
            this.handleGenModelPath(this._genModelPath);
        }
        finally {
            monitor.done();
        }
    }

    private void handleGenModelPath(IPath genModelPath) {
        ModelImporter modelImporter = this.getModelImporter();
        modelImporter.setGenModelContainerPath(this._genModelContainerPath);
        modelImporter.setGenModelFileName(genModelPath.toString());
    }

    protected IPath getGenModelContainer() {
        IPath relativePath;
        Path result = new Path(this.getModelPluginId());
        File physicalFile = this.getInputPath().toFile();
        result = physicalFile.isDirectory() ? result.append(MODEL_FOLDER) : ((relativePath = this.getInputPath().removeFirstSegments(1).removeLastSegments(1).removeFileExtension()).segmentCount() > 0 ? result.append(relativePath) : result.append(MODEL_FOLDER));
        return result;
    }

    private boolean handleEPackages(Monitor monitor) {
        boolean result = true;
        try {
            try {
                ModelImporter modelImporter = this.getModelImporter();
                Diagnostic diagnostic = modelImporter.computeEPackages(monitor);
                result = this.handleDiagnostic(diagnostic, "Computes EPackages error");
                if (result) {
                    this.handleReferencedPackages(modelImporter, monitor);
                    modelImporter.adjustEPackages(monitor);
                }
            }
            catch (Exception exception) {
                StringBuffer loggerMessage = new StringBuffer("AbstractGenModelGenerator.handleEPackages(..) _ ");
                _logger.warn((Object)loggerMessage.toString(), (Throwable)exception);
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    protected void addExternalGenModels(List<GenModel> genModels) {
        ModelImporter modelImporter = this.getModelImporter();
        ArrayList externalGenModels = new ArrayList(modelImporter.getExternalGenModels());
        if (!externalGenModels.isEmpty()) {
            boolean hasExporterGenModel;
            GenModel exporterGenModel = modelImporter.getGenModel();
            boolean bl = hasExporterGenModel = exporterGenModel != null && genModels.contains(exporterGenModel);
            if (!hasExporterGenModel) {
                genModels.add(exporterGenModel);
            }
            for (GenModel genModel : genModels) {
                Iterator j = externalGenModels.iterator();
                while (j.hasNext()) {
                    URI externalURI;
                    URI uri;
                    GenModel externalGenModel = (GenModel)j.next();
                    if (genModel == externalGenModel) {
                        j.remove();
                        continue;
                    }
                    URI uRI = uri = genModel.eResource() != null ? genModel.eResource().getURI() : null;
                    if (uri == null) continue;
                    URI uRI2 = externalURI = externalGenModel.eResource() != null ? externalGenModel.eResource().getURI() : null;
                    if (!uri.equals(externalURI)) continue;
                    j.remove();
                }
            }
            genModels.addAll(externalGenModels);
            if (!hasExporterGenModel) {
                genModels.remove(exporterGenModel);
            }
        }
    }

    public void setPluginId(String pluginId) {
        this._modelPluginId = pluginId;
    }

    public void setBasePackagePrefix(String basePackage) {
        this._basePackage = basePackage;
    }

    public void setInputPath(IPath inputPath) {
        this._inputPath = inputPath;
    }

    protected IPath getInputPath() {
        return this._inputPath;
    }

    protected String getModelPluginId() {
        return this._modelPluginId;
    }

    protected String getRootExtendsInterface() {
        return this._rootExtendsInterface;
    }

    public void clear() {
        this._modelImporter = null;
        this._inputPath = null;
        this._modelPluginId = null;
        this._basePackage = null;
        this._genModelPath = null;
        this._genModelContainerPath = null;
        this._rootExtendsInterface = null;
        this._rootExtendsClass = null;
        this._jdkComplianceLevel = null;
    }

    public void setRootExtendsInterface(String rootExtendsInterface) {
        this._rootExtendsInterface = rootExtendsInterface;
    }

    public void setRootExtendsClass(String rootExtendsClass) {
        this._rootExtendsClass = rootExtendsClass;
    }

    public void setJdkComplianceLevel(GenJDKLevel jdkComplianceLevel) {
        this._jdkComplianceLevel = jdkComplianceLevel;
    }

    public void setModelDirectory(String modelDirectory) {
        this._modelDirectory = modelDirectory;
    }

    public void setOperationReflection(boolean operationReflection) {
        this._operationReflection = operationReflection;
    }

    public void setResourceType(GenResourceKind resourceType) {
        this._resourcetype = resourceType;
    }

    public void setPackagesSuffixes(String implementationPackageSuffix, String interfacePackageSuffix, String metadataPackageSuffix, String utilityPackageSuffix) {
        this._implementationPackageSuffix = implementationPackageSuffix;
        this._interfacePackageSuffix = interfacePackageSuffix;
        this._metadataPackageSuffix = metadataPackageSuffix;
        this._utilityPackageSuffix = utilityPackageSuffix;
    }
}

