/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyOption;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;

public class OptionRenderer
extends AbstractRenderer {
    Group options;
    Collection<Button> buttons;

    @Override
    public void performRender(Composite parent, final IRendererContext rendererContext) {
        final IProperty property = rendererContext.getProperty(this);
        IPropertyContext propertyContext = rendererContext.getPropertyContext();
        this.options = new Group(parent, 0);
        this.options.setText(property.getName());
        this.options.setData((Object)property);
        this.options.setEnabled(property.isEnabled(propertyContext));
        if (parent.getLayout() instanceof GridLayout) {
            this.options.setLayout((Layout)new GridLayout(1, false));
            this.options.setLayoutData((Object)new GridData(768));
        }
        this.buttons = new ArrayList<Button>();
        for (IPropertyOption option : property.getOptions()) {
            Button dataExport = new Button((Composite)this.options, 16);
            dataExport.setText(option.getName());
            dataExport.setData((Object)option);
            dataExport.setEnabled(option.isEnabled() && property.isEnabled(propertyContext));
            dataExport.setToolTipText(option.getDescription());
            dataExport.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    Object newValue;
                    Button b = (Button)e.widget;
                    if (b.getSelection() && (newValue = b.getData()) != null && newValue instanceof IPropertyOption) {
                        String value = ((IPropertyOption)newValue).getValue();
                        OptionRenderer.this.changeValue(property, rendererContext, value);
                        OptionRenderer.this.updatedValue(property, rendererContext, value);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.buttons.add(dataExport);
        }
    }

    @Override
    public void initialize(IProperty property, IRendererContext propertyContext) {
        Object value = propertyContext.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, propertyContext, value);
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext propertyContext, Object newValue) {
        if (property.equals(propertyContext.getProperty(this))) {
            for (Button button : this.buttons) {
                if (button.getData() == null || !(button.getData() instanceof IPropertyOption)) continue;
                IPropertyOption option = (IPropertyOption)button.getData();
                button.setSelection(option.getValue().equals(newValue));
            }
        }
    }

    @Override
    public void dispose(IRendererContext context) {
        this.options.dispose();
    }
}

