/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.ui.renderers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.common.flexibility.properties.PropertyChangeListener;
import org.polarsys.capella.common.flexibility.properties.PropertyChangedEvent;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.EditListRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.DefaultLabelProvider;
import org.polarsys.capella.common.re.handlers.attributes.AttributesHandlerHelper;
import org.polarsys.capella.common.re.handlers.scope.DependenciesHandlerHelper;
import org.polarsys.capella.common.re.ui.decorators.InstanciationLabelDecorator;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReplicaRenderer
extends EditListRenderer
implements PropertyChangeListener {
    ILabelProvider _defaultProvider;

    protected int getExpandLevel() {
        return -1;
    }

    public void performRender(Composite parent, IRendererContext rendererContext) {
        super.performRender(parent, rendererContext);
    }

    protected Object createInput(IProperty property, IRendererContext propertyContext) {
        return super.createInput(property, propertyContext);
    }

    public void updatedValue(IProperty property, IRendererContext propertyContext, Object newValue) {
        AbstractData data = (AbstractData)super.createInput(property, propertyContext);
        AbstractData menu = (AbstractData)this.getViewer().getClientViewer().getInput();
        if (menu != null) {
            menu.removeAllElements(menu.getValidElements().toArray());
            menu.addAllElements(data.getValidElements().toArray());
            this.getViewer().getClientViewer().refresh();
        } else {
            this.reloadInput(property, propertyContext);
        }
    }

    protected ILabelProvider createLabelProvider(final IRendererContext rendererContext) {
        this._defaultProvider = super.createLabelProvider(rendererContext);
        final InstanciationLabelDecorator decorator = new InstanciationLabelDecorator();
        return new DefaultLabelProvider(rendererContext.getLabelProvider()){

            public Font getBold(Font font) {
                Font result = JFaceResources.getFontRegistry().getBold(JFaceResources.getFontRegistry().defaultFont().getFontData()[0].getName());
                return result;
            }

            public Color getBackground(Object element) {
                return ((IColorProvider)ReplicaRenderer.this._defaultProvider).getBackground(element);
            }

            public Color getForeground(Object element) {
                IStatus status = this.isImportant(element, rendererContext);
                if (status.matches(1)) {
                    return Display.getCurrent().getSystemColor(12);
                }
                return ((IColorProvider)ReplicaRenderer.this._defaultProvider).getForeground(element);
            }

            public String getText(Object object) {
                IStatus status;
                if (object instanceof EStructuralFeature) {
                    return ((EStructuralFeature)object).getName();
                }
                Collection scopeElements = (Collection)rendererContext.getPropertyContext().getCurrentValue(rendererContext.getPropertyContext().getProperties().getProperty("source.scopeElements"));
                Collection allScopeElements = (Collection)rendererContext.getPropertyContext().getCurrentValue(rendererContext.getPropertyContext().getProperties().getProperty("source.allScopeElements"));
                String text = super.getText(object);
                if (allScopeElements.contains(object)) {
                    text = decorator.decorateText(text, object);
                }
                if (!(status = this.isImportant(object, rendererContext)).isOK() && !status.getMessage().isEmpty()) {
                    return NLS.bind((String)"{0} [{1}]", (Object)text, (Object)status.getMessage());
                }
                return text;
            }

            public Font getFont(Object element) {
                IStatus status;
                Font f = super.getFont(element);
                if (f == null) {
                    f = ((IFontProvider)ReplicaRenderer.this._defaultProvider).getFont(element);
                }
                if ((status = this.isImportant(element, rendererContext)) == null || status.isOK()) {
                    return super.getFont(element);
                }
                if (status.matches(2)) {
                    return this.getBold(f);
                }
                return super.getFont(element);
            }

            protected IStatus isImportant(Object element, IRendererContext context) {
                Collection scopeElements = (Collection)context.getPropertyContext().getCurrentValue(context.getPropertyContext().getProperties().getProperty("source.scopeElements"));
                Collection allScopeElements = (Collection)context.getPropertyContext().getCurrentValue(context.getPropertyContext().getProperties().getProperty("source.allScopeElements"));
                if (!allScopeElements.contains(element)) {
                    return Status.OK_STATUS;
                }
                if (!scopeElements.contains(element)) {
                    return new Status(1, "org.polarsys.capella.common.re.ui", "");
                }
                IContext ctx = (IContext)context.getPropertyContext().getSource();
                if (AttributesHandlerHelper.getInstance((IContext)ctx).isSuffixable(element, ctx)) {
                    return new Status(2, "org.polarsys.capella.common.re.ui", "+SUFFIX");
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected IStatus getStatus(Object element, IRendererContext rendererContext) {
        Collection scopeElements = (Collection)rendererContext.getPropertyContext().getCurrentValue(rendererContext.getPropertyContext().getProperties().getProperty("source.scopeElements"));
        if (!scopeElements.contains(element)) {
            return Status.OK_STATUS;
        }
        IContext context = (IContext)rendererContext.getPropertyContext().getSource();
        IStatus status = this.getDependenciesStatus(Collections.singletonList((EObject)element), scopeElements, context);
        return status;
    }

    public IStatus getDependenciesStatus(Collection<EObject> elements, Collection<EObject> scopeElements, IContext context) {
        Collection values = DependenciesHandlerHelper.getInstance((IContext)context).getDependencies(elements, scopeElements, context);
        if (values.isEmpty()) {
            return Status.OK_STATUS;
        }
        return new Status(2, "org.polarsys.capella.common.re.ui", "Missing dependencies");
    }

    public void initialize(IProperty property, IRendererContext rendererContext) {
        rendererContext.getPropertyContext().getCurrentValue(rendererContext.getPropertyContext().getProperties().getProperty("suffixes"));
        super.initialize(property, rendererContext);
        rendererContext.getPropertyContext().registerListener((PropertyChangeListener)this, rendererContext.getPropertyContext().getProperties().getProperty("suffixes"));
    }

    protected String getToolbarLocation() {
        return "toolbar:org.polarsys.capella.common.re.createRec";
    }

    protected void initializeControls(Composite parent, IRendererContext context) {
        super.initializeControls(parent, context);
    }

    public void dispose(IRendererContext context) {
        super.dispose(context);
    }

    public void update(PropertyChangedEvent event) {
        if ("suffixes".equals(event.getProperty().getId())) {
            this.getViewer().getClientViewer().refresh();
        }
    }
}

