/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.capellaHelpers;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class HashMapSet<K, V> {
    boolean isOrdonned = false;
    Comparator<V> comparator;
    HashMap<K, Object> map = new HashMap();

    public HashMapSet() {
    }

    public void clear() {
        if (this.map != null) {
            this.map.clear();
        }
    }

    protected Set<V> createInternalSet() {
        if (this.isOrdonned) {
            return new InternalTreeSet();
        }
        return new InternalHashSet();
    }

    public HashMapSet(Comparator<V> comparator) {
        this.comparator = comparator;
        this.isOrdonned = true;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public boolean containsKey(K k) {
        return this.map.keySet().contains(k);
    }

    public Set<K> subKeySet(Collection<K> keys) {
        HashSet<K> subSet = new HashSet<K>();
        Set<K> set = this.keySet();
        for (K key : keys) {
            if (!set.contains(key)) continue;
            subSet.add(key);
        }
        return subSet;
    }

    public Collection<V> get(K obj) {
        if (this.map.get(obj) == null) {
            return this.createInternalSet();
        }
        if (!(this.map.get(obj) instanceof Set)) {
            Set<V> a = this.createInternalSet();
            a.add(this.map.get(obj));
            this.map.put(obj, a);
            return a;
        }
        return (Collection)this.map.get(obj);
    }

    public boolean contains(K obj) {
        return this.get(obj).size() != 0;
    }

    public void remove(K obj) {
        if (this.map.get(obj) != null) {
            this.map.remove(obj);
        }
    }

    public void remove(K obj, V arg1) {
        if (this.map.get(obj) != null) {
            if (this.map.get(obj).equals(arg1)) {
                this.map.remove(obj);
            } else if (this.map.get(obj) instanceof Collection) {
                Collection a = (Collection)this.map.get(obj);
                a.remove(arg1);
                if (a.size() == 0) {
                    this.map.remove(obj);
                } else if (a.size() == 1) {
                    this.map.remove(obj);
                    this.put(obj, arg1);
                }
            }
        }
    }

    public void put(K arg0, V arg1) {
        if (this.map.get(arg0) == null) {
            this.map.put(arg0, arg1);
        } else {
            if (!(this.map.get(arg0) instanceof Set)) {
                Set<V> a = this.createInternalSet();
                a.add(this.map.get(arg0));
                this.map.put(arg0, a);
            }
            ((Collection)this.map.get(arg0)).add(arg1);
        }
    }

    public void putAll(K arg0, List<V> arg1) {
        for (V v : arg1) {
            this.put(arg0, v);
        }
    }

    private class InternalHashSet
    extends HashSet<V>
    implements InternalSet {
        private static final long serialVersionUID = -1399521010073092265L;
    }

    private static interface InternalSet {
    }

    private class InternalTreeSet
    extends TreeSet<V>
    implements InternalSet {
        private static final long serialVersionUID = 4461070833994342245L;

        public InternalTreeSet() {
            super(HashMapSet.this.comparator);
        }
    }
}

