/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.capella.core.transition.common.transposer.CadenceExtensions;
import org.polarsys.kitalpha.cadence.core.api.CadenceValidator;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;

public class ExtendedCadenceLauncher {
    private Map<String, ParameterError<?>> wrongParams = null;
    public final String PARAMETER_DEFINITION = "ParameterDefinition";

    public IStatus cadence(String workflow_id, String workflowElement_id, WorkflowActivityParameter workflowActivityParameters) throws Exception {
        return this.cadence(workflow_id, workflowElement_id, workflowActivityParameters, null);
    }

    public IStatus cadence(String workflow_id, String workflowElement_id, WorkflowActivityParameter workflowActivityParameters, IProgressMonitor monitor) throws Exception {
        int candidateSize;
        Set activitiesID;
        MultiStatus result = new MultiStatus("org.polarsys.kitalpha.cadence.core", 0, this.getStatusMessage(workflow_id, workflowElement_id), null){

            public String getMessage() {
                String message = super.getMessage();
                if (this.getChildren() != null) {
                    message = String.valueOf(message) + ' ';
                    message = String.valueOf(message) + '(';
                    int i = 0;
                    IStatus[] iStatusArray = this.getChildren();
                    int n = iStatusArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IStatus child = iStatusArray[n2];
                        message = String.valueOf(message) + child.getMessage();
                        if (this.getChildren().length != ++i) {
                            message = String.valueOf(message) + ';';
                        }
                        ++n2;
                    }
                    message = String.valueOf(message) + ')';
                }
                return message;
            }
        };
        boolean isMultiple = CadenceExtensions.isMultiple(workflow_id, workflowElement_id);
        if (workflowActivityParameters != null) {
            activitiesID = workflowActivityParameters.getActivitiesID();
            candidateSize = workflowActivityParameters.getActivitiesID().size();
        } else {
            activitiesID = Collections.emptySet();
            candidateSize = 0;
        }
        if (monitor != null) {
            IConfigurationElement workflow = CadenceExtensions.getWorkflow(workflow_id);
            IConfigurationElement workflowElement = CadenceExtensions.getWorkflowElement(workflow_id, workflowElement_id);
            String workflowName = workflow == null ? workflow_id : workflow.getAttribute("Name");
            String workflowElementName = workflowElement == null ? workflowElement_id : workflowElement.getAttribute("Name");
            monitor.beginTask(this.getTaskName(workflowName, workflowElementName), candidateSize);
        }
        if (candidateSize <= 1 || candidateSize > 1 && isMultiple) {
            for (String activityID : activitiesID) {
                ActivityParameters activityParameters;
                IStatus status = this.cadence(workflow_id, workflowElement_id, activityID, activityParameters = workflowActivityParameters.getActivityParameters(activityID), monitor);
                if (status != null) {
                    if (status.matches(8) || status.matches(4)) {
                        result.add(status);
                        break;
                    }
                    result.add(status);
                }
                if (monitor == null) continue;
                monitor.worked(1);
            }
        } else {
            throw new Exception("the workflowElement " + workflowElement_id + " is not multiple.");
        }
        if (monitor != null) {
            monitor.done();
        }
        return result;
    }

    protected String getTaskName(String workflowName, String workflowElementName) {
        return "Cadence " + workflowName + " : " + workflowElementName;
    }

    protected String getStatusMessage(String workflowName, String workflowElementName) {
        return "Cadence activities";
    }

    public IStatus cadence(String workflow_id, String workflowElement_id, String activityElement_id, ActivityParameters activityParameters) {
        return this.cadence(workflow_id, workflowElement_id, activityElement_id, activityParameters, null);
    }

    public IStatus cadence(String workflow_id, String workflowElement_id, String activityElement_id, ActivityParameters activityParameters, IProgressMonitor monitor) {
        IConfigurationElement workflowElement = CadenceExtensions.getWorkflowElement(workflow_id, workflowElement_id);
        IConfigurationElement activityElement = CadenceExtensions.getActivityConfigElement(activityElement_id);
        if (activityElement == null) {
            throw new RuntimeException(NLS.bind((String)"Activity ''{0}'' is not registered.", (Object)activityElement_id));
        }
        if (monitor != null) {
            String activityName = activityElement.getAttribute("Name");
            monitor.subTask(activityName);
        }
        IStatus status = this.cadence(workflowElement, activityElement, activityParameters);
        return status;
    }

    private IStatus cadence(IConfigurationElement workflowElement, IConfigurationElement activityElement, ActivityParameters activityParameters) {
        IStatus status;
        block3: {
            status = null;
            try {
                IActivity activity = (IActivity)activityElement.createExecutableExtension("ActivityClass");
                if (workflowElement != null && (activityParameters == null || !this.matchParameters(workflowElement, activityParameters))) break block3;
                this.wrongParams = activity.validateParameters(activityParameters);
                if (this.wrongParams == null || this.wrongParams.isEmpty()) {
                    status = activity.run(activityParameters);
                    break block3;
                }
                throw new Exception("activity's parameters are not valid. " + CadenceValidator.getParameterErrorsTrace(this.wrongParams));
            }
            catch (Exception e) {
                throw new TransitionException(e);
            }
        }
        return status;
    }

    private boolean matchParameters(IConfigurationElement workflowElement, ActivityParameters activityParameters) throws Exception {
        if (activityParameters != null) {
            IConfigurationElement[] params = CadenceExtensions.getWorkflowElementParameters(workflowElement);
            if (activityParameters.getParameters().size() < params.length) {
                throw new Exception("activity doesn't define parameters enough");
            }
            IConfigurationElement[] iConfigurationElementArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement p = iConfigurationElementArray[n2];
                String name = p.getAttribute("Name");
                if (!activityParameters.getParametersID().contains(name)) {
                    throw new Exception("The org.polarsys.kitalpha.cadence.core.api.parameter " + name + " doesn't exist.");
                }
                ++n2;
            }
        }
        return true;
    }

    public IConfigurationElement[] getWorkflowElementParameters(IConfigurationElement workflowElement) {
        return workflowElement.getChildren("ParameterDefinition");
    }
}

